/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class HashedArrayList<T>
extends ArrayList<T> {
    private static final long serialVersionUID = -7827380207842473120L;
    private final transient Map<T, Integer> objectToIndex;

    public HashedArrayList(Collection<? extends T> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public HashedArrayList(int size) {
        super(size);
        this.objectToIndex = new HashMap<T, Integer>(size);
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T element) {
        Assert.isNotNull(element, (String)"added element must not be null");
        if (this.objectToIndex.containsKey(element)) {
            return false;
        }
        boolean added = super.add(element);
        this.objectToIndex.put(element, this.size() - 1);
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        for (T object : c) {
            modified |= this.add(object);
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.objectToIndex.clear();
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.objectToIndex.containsKey(o);
    }

    @Override
    public int indexOf(Object o) {
        Integer index = this.objectToIndex.get(o);
        return index == null ? -1 : index;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public T remove(int index) {
        Object removed = super.remove(index);
        this.objectToIndex.remove(removed);
        this.reindex(index);
        return (T)removed;
    }

    @Override
    public boolean remove(Object o) {
        Integer indexObject = this.objectToIndex.get(o);
        if (indexObject == null) {
            return false;
        }
        return this.remove(indexObject) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T element) {
        Assert.isNotNull(element, (String)"element must not be null");
        T former = super.set(index, element);
        if (former.equals(element)) {
            return former;
        }
        Integer indexOfElement = this.objectToIndex.put(element, index);
        if (indexOfElement != null) {
            this.set((int)indexOfElement, former);
        } else {
            this.objectToIndex.remove(former);
        }
        return former;
    }

    protected void reindex(int index) {
        int i = index;
        while (i < this.size()) {
            this.objectToIndex.put(this.get(i), i);
            ++i;
        }
    }
}

