/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.utils;

import java.util.Map;
import java.util.TreeMap;

public class StepTimeTracker {
    private final Map<String, Step> steps = new TreeMap<String, Step>();
    private final long start;
    private final String name;
    private long last;

    public StepTimeTracker() {
        this("");
    }

    public StepTimeTracker(String name) {
        this.name = name;
        this.last = this.start = System.currentTimeMillis();
    }

    public String finish() {
        this.step("finished");
        return this.toString();
    }

    public Step getStep(String name) {
        return this.steps.get(name);
    }

    public void step(String name) {
        long now = System.currentTimeMillis();
        long delta = now - this.last;
        Step step = this.steps.get(name);
        if (step == null) {
            step = new Step(name, delta);
            this.steps.put(name, step);
        } else {
            step.add(delta);
        }
        this.last = now;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append(" ");
        for (Map.Entry<String, Step> step : this.steps.entrySet()) {
            builder.append(step.getValue());
        }
        return builder.toString();
    }

    public static class Step {
        private final String name;
        private int ticks = 1;
        private long lastStepTime;
        private long totalTime;

        private Step(String name, long last) {
            this.name = name;
            this.lastStepTime = last;
            this.totalTime = last;
        }

        public int getCounter() {
            return this.ticks;
        }

        public long getLastStepTime() {
            return this.lastStepTime;
        }

        public String getName() {
            return this.name;
        }

        public long getTotalTimeInStep() {
            return this.totalTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.name);
            builder.append(" ");
            builder.append("lastStepTime=" + this.lastStepTime);
            builder.append("ms");
            if (this.ticks == 1) {
                builder.append("]");
                return builder.toString();
            }
            builder.append(", totalTime=");
            builder.append(this.totalTime);
            builder.append("ms, ticks=");
            builder.append(this.ticks);
            builder.append(", averageTime=");
            builder.append(this.totalTime / (long)this.ticks);
            builder.append("ms]");
            return builder.toString();
        }

        private void add(long last) {
            ++this.ticks;
            this.lastStepTime = last;
            this.totalTime += last;
        }
    }
}

