/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.auth;

import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.model.node.INode;
import org.eclipse.swt.graphics.Color;

public final class AuthenticationEvent
extends StudioEvent {
    public static final String TOPIC = "studio/authentication";

    public AuthenticationEvent(Type eventType) {
        super(TOPIC);
        this.data.put(Property.STATUS.value, eventType);
    }

    protected AuthenticationEvent(Type eventType, AuthenticationEvent event) {
        super(TOPIC);
        this.data.putAll(event.data);
        this.data.put(Property.STATUS.value, eventType);
    }

    public Color getColor() {
        return (Color)this.data.get(Property.COLOR.value);
    }

    public Type getEventType() {
        return (Type)((Object)this.data.get(Property.STATUS.value));
    }

    public Long getId() {
        return (Long)this.data.get(Property.ID.value);
    }

    public String getLogin() {
        return (String)this.data.get(Property.LOGIN.value);
    }

    public String getMessage() {
        return (String)this.data.get(Property.MESSAGE.value);
    }

    public INode getProfile() {
        Object profile = this.data.get(Property.PROFILE.value);
        if (profile != null) {
            return (INode)profile;
        }
        return null;
    }

    public String getPwd() {
        return (String)this.data.get(Property.PWD.value);
    }

    public AuthenticationEvent setColor(Color color) {
        this.data.put(Property.COLOR.value, color);
        return this;
    }

    public AuthenticationEvent setId(Long id) {
        this.data.put(Property.ID.value, id);
        return this;
    }

    public AuthenticationEvent setLogin(String login) {
        this.data.put(Property.LOGIN.value, login);
        return this;
    }

    public AuthenticationEvent setMessage(String message) {
        this.data.put(Property.MESSAGE.value, message);
        return this;
    }

    public AuthenticationEvent setProfile(INode profile) {
        this.data.put(Property.PROFILE.value, profile);
        return this;
    }

    public AuthenticationEvent setPwd(String pwd) {
        this.data.put(Property.PWD.value, pwd);
        return this;
    }

    static enum Property {
        ID("id"),
        PWD("pwd"),
        LOGIN("login"),
        STATUS("status"),
        MESSAGE("message"),
        PROFILE("profile"),
        COLOR("color");

        final String value;

        private Property(String value) {
            this.value = value;
        }
    }

    public static enum Type {
        REQUEST_LOGIN("request.login"),
        REQUEST_LOGOUT("request.logout"),
        REQUEST_FORCED_LOGOUT("request.forced.logout"),
        DO_LOGIN("do.login"),
        DO_LOGOUT("do.logout"),
        DO_QUIT("do.quit"),
        LOGGED_IN("logged.in"),
        LOGGED_OUT("logged.out"),
        LOGGED_FAILED("logged.failed");

        final String value;

        private Type(String value) {
            this.value = value;
        }
    }
}

