/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.events.auth;

import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.model.node.INode;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Color;
import org.osgi.service.event.Event;

public abstract class AuthenticationEventHandler
extends StudioEventHandler<AuthenticationEvent> {
    private static final Collection<AuthenticationEventHandler> HANDLERS = new ArrayList<AuthenticationEventHandler>(20);
    protected AuthenticationEvent lastEvent;

    public AuthenticationEventHandler() {
        HANDLERS.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handleEvent(AuthenticationEvent event) {
        Collection<AuthenticationEventHandler> collection = HANDLERS;
        synchronized (collection) {
            this.lastEvent = event;
            switch (event.getEventType()) {
                case REQUEST_LOGIN: {
                    this.requestLogin();
                    break;
                }
                case REQUEST_LOGOUT: {
                    this.requestLogout();
                    break;
                }
                case REQUEST_FORCED_LOGOUT: {
                    this.forcedLogout();
                    this.lastEvent = null;
                    break;
                }
                case DO_LOGIN: {
                    INode profile = event.getProfile();
                    this.doLogin(profile);
                    break;
                }
                case DO_LOGOUT: {
                    this.doLogout();
                    break;
                }
                case DO_QUIT: {
                    this.doQuit();
                    break;
                }
                case LOGGED_IN: {
                    this.loggedIn();
                    break;
                }
                case LOGGED_OUT: {
                    this.loggedOut();
                    this.lastEvent = null;
                    break;
                }
                case LOGGED_FAILED: {
                    this.loggedFail();
                    break;
                }
            }
            this.sendNextEvent();
        }
    }

    @Override
    protected AuthenticationEvent adapt(Event event) {
        Assert.isTrue((boolean)"studio/authentication".equals(event.getTopic()));
        AuthenticationEvent.Type eventType = (AuthenticationEvent.Type)((Object)event.getProperty(AuthenticationEvent.Property.STATUS.value));
        AuthenticationEvent authenticationEvent = new AuthenticationEvent(eventType);
        return authenticationEvent.setProfile((INode)event.getProperty(AuthenticationEvent.Property.PROFILE.value)).setMessage((String)event.getProperty(AuthenticationEvent.Property.MESSAGE.value)).setLogin((String)event.getProperty(AuthenticationEvent.Property.LOGIN.value)).setPwd((String)event.getProperty(AuthenticationEvent.Property.PWD.value)).setId((Long)event.getProperty(AuthenticationEvent.Property.ID.value)).setColor((Color)event.getProperty(AuthenticationEvent.Property.COLOR.value));
    }

    protected boolean doLogin(INode profile) {
        return false;
    }

    protected void doLogout() {
    }

    protected void doQuit() {
    }

    protected void forcedLogout() {
    }

    protected void loggedFail() {
    }

    protected void loggedIn() {
    }

    protected void loggedOut() {
    }

    protected void requestLogin() {
    }

    protected void requestLogout() {
    }

    private void sendNextEvent() {
        for (AuthenticationEventHandler handler : HANDLERS) {
            boolean notSameEventType;
            if (handler.lastEvent == null || this.lastEvent == null) {
                return;
            }
            boolean bl = notSameEventType = handler.lastEvent.getEventType() != this.lastEvent.getEventType();
            if (!notSameEventType) continue;
            return;
        }
        if (this.lastEvent.getEventType() != AuthenticationEvent.Type.REQUEST_LOGOUT) {
            return;
        }
        AuthenticationEvent nextEvent = new AuthenticationEvent(AuthenticationEvent.Type.DO_LOGOUT, this.lastEvent);
        for (AuthenticationEventHandler handler : HANDLERS) {
            handler.handleEvent(nextEvent);
        }
    }
}

