/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media;

import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.media.model.MediaRepository;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.media.model.MediaWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MediaSyncEventHandler
extends SyncEventHandler {
    private static long TTL_TIMEOUT = 5000L;
    private final Map<Long, Long> ttlMap = new HashMap<Long, Long>(50);
    private final MediaRepository repository;
    private final MediaWebService service;

    private static boolean isRelation(Integer type) {
        return type.equals(MediaTypes.MEDIA_RELATION.getId()) || type.equals(MediaTypes.MEDIA_RELATION_IMAGE.getId()) || type.equals(MediaTypes.MEDIA_RELATION_SOUND.getId());
    }

    public MediaSyncEventHandler(MediaRepository repository, MediaWebService service) {
        super(Arrays.asList(MediaTypes.MEDIA_GROUP.getId(), MediaTypes.MEDIA_SOUND.getId(), MediaTypes.MEDIA_IMAGE.getId(), MediaTypes.MEDIA_RELATION.getId(), MediaTypes.MEDIA_RELATION_SOUND.getId(), MediaTypes.MEDIA_RELATION_IMAGE.getId()));
        this.repository = repository;
        this.service = service;
    }

    public void handleEvent(SyncEvent event) {
        block13: {
            ArrayList ids;
            block14: {
                block12: {
                    Collection datas = event.getData();
                    HashSet<Long> uniqueIds = new HashSet<Long>(datas.size());
                    for (SyncEvent.SyncData data : datas) {
                        uniqueIds.add(data.getId());
                    }
                    Iterator<Map.Entry<Long, Long>> it = this.ttlMap.entrySet().iterator();
                    if (MediaSyncEventHandler.isRelation(event.getType())) {
                        while (it.hasNext()) {
                            Map.Entry<Long, Long> entry = it.next();
                            if (System.currentTimeMillis() - entry.getValue() < TTL_TIMEOUT) {
                                uniqueIds.add(entry.getKey());
                                continue;
                            }
                            it.remove();
                        }
                    }
                    ids = new ArrayList(uniqueIds);
                    if (event.getAction() != SyncEvent.SyncAction.CREATE) break block12;
                    List relations = MediaSyncEventHandler.isRelation(event.getType()) ? this.service.getRelationsByIds(ids) : this.service.getElementsByIds(ids);
                    for (Long l : ids) {
                        boolean relationFounded = false;
                        for (INodeRelation loadedRelation : relations) {
                            if (!l.equals(loadedRelation.getId())) continue;
                            relationFounded = true;
                            break;
                        }
                        if (relationFounded) continue;
                        this.ttlMap.put(l, System.currentTimeMillis());
                    }
                    for (INodeRelation iNodeRelation : relations) {
                        INode parent = (INode)iNodeRelation.getSource().adapt(INode.class);
                        if (INodeUtils.findNode((INode)parent, (TypeDescriptor)iNodeRelation.getTarget().getType(), (Long)iNodeRelation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]) != null) continue;
                        parent.addRelation(iNodeRelation);
                    }
                    break block13;
                }
                if (event.getAction() != SyncEvent.SyncAction.UPDATE) break block14;
                List relations = MediaSyncEventHandler.isRelation(event.getType()) ? this.service.getRelationsByIds(ids) : this.service.getElementsByIds(ids);
                for (INodeRelation iNodeRelation : relations) {
                    INode existing = INodeUtils.findNode((INode)this.repository, (TypeDescriptor)iNodeRelation.getTarget().getType(), (Long)iNodeRelation.getTarget().getId(), (PropertyValue[])new PropertyValue[0]);
                    if (existing != null) {
                        INodeUtils.updateProperties((IObject)existing, (Collection)iNodeRelation.getTarget().getPropertyValues(), (boolean)true, (boolean)true, (String[])new String[0]);
                        continue;
                    }
                    iNodeRelation.getSource().addRelation(iNodeRelation);
                }
                break block13;
            }
            if (event.getAction() != SyncEvent.SyncAction.REMOVE) break block13;
            HashMap<INode, ArrayList<INodeRelation>> mapToRemove = new HashMap<INode, ArrayList<INodeRelation>>(ids.size());
            for (Long l : ids) {
                INodeRelation relation;
                INodeRelation iNodeRelation = relation = MediaSyncEventHandler.isRelation(event.getType()) ? INodeUtils.findRelation((INode)this.repository, (Long)l, (TypeDescriptor[])new TypeDescriptor[0]) : INodeUtils.findRelationForTarget((INode)this.repository, null, (Long)l, (PropertyValue[])new PropertyValue[0]);
                if (relation == null) continue;
                ArrayList<INodeRelation> elementsToRemove = (ArrayList<INodeRelation>)mapToRemove.get(relation.getSource());
                if (elementsToRemove == null) {
                    elementsToRemove = new ArrayList<INodeRelation>(1);
                    mapToRemove.put(relation.getSource(), elementsToRemove);
                }
                elementsToRemove.add(relation);
            }
            for (Map.Entry entry : mapToRemove.entrySet()) {
                ((INode)entry.getKey()).removeRelations((Collection)entry.getValue());
            }
        }
    }
}

