/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.model;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.media.MediaAddon;
import com.centreon.studio.client.utils.StreamUtils;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.map.dataservice.DataFault;
import com.centreon.studio.map.dataservice.DataPortType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class DataWebService
extends AWebService<DataPortType> {
    private final BrokerEventManager eventManager;

    @Inject
    public DataWebService(BrokerEventManager eventManager) {
        super("/centreon-studio/services/data?wdsl", DataPortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File download(String md5) {
        String base64;
        File file;
        block20: {
            if (StringUtils.isNullEmptyOrBlank((String)md5)) {
                return null;
            }
            file = new File(MediaAddon.MEDIA_HOME, md5);
            if (this.checkMd5(file, md5)) {
                return file;
            }
            if (!this.isInit()) {
                return null;
            }
            base64 = ((DataPortType)this.service).download(md5);
            if (base64 != null) break block20;
            return null;
        }
        try {
            byte[] data = DatatypeConverter.parseBase64Binary((String)base64);
            this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Got media {} file from server", (Object[])new Object[]{md5}));
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                        StreamUtils.copy((InputStream)bais, (OutputStream)fos);
                    }
                    if (fos == null) return file;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return file;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String md5, File file) {
        try {
            if (((DataPortType)this.service).download(md5) != null) {
                return true;
            }
        }
        catch (DataFault dataFault) {}
        StringBuilder errors = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream fis = new FileInputStream(file);
                try {
                    block22: {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        String base64Data = "";
                        if (!file.exists()) {
                            errors.append("Input file '");
                            errors.append(file.getAbsolutePath());
                            errors.append("' does not exists.");
                            errors.append(StringUtils.NEW_LINE);
                            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)new Exception(errors.toString())));
                        }
                        StreamUtils.copy((InputStream)fis, (OutputStream)baos);
                        base64Data = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
                        ((DataPortType)this.service).upload(md5, base64Data);
                        finally {
                            if (baos == null) break block22;
                            baos.close();
                        }
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    return false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception e) {
            errors.append("An error happened during import of file '");
            errors.append(file.getAbsolutePath());
            errors.append("'.");
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)new Exception(errors.toString(), e)));
            return false;
        }
    }

    protected boolean isWebServiceInitialized() {
        try {
            ((DataPortType)this.service).download("test");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkMd5(File file, String md5) {
        if (!file.exists() || StringUtils.isNullEmptyOrBlank((String)md5)) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                return md5.equals(StreamUtils.md5((InputStream)fis));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return false;
        }
    }
}

