/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.media.model;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.media.MediaAddon;
import com.centreon.studio.client.media.model.MediaPropertyDescriptors;
import com.centreon.studio.client.media.model.MediaTypes;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.activation.MimetypesFileTypeMap;

public final class MediaUtils {
    private static final String INPUT_FILE = "input file '";
    private static final String IMPORT_IGNORED = ", import is ignored" + StringUtils.NEW_LINE;
    private static final Set<String> AUDIO_MIME_TYPES = new HashSet<String>();
    private static final Set<String> IMAGE_MIME_TYPES;
    private static final Set<String> BITMAP_MIME_TYPES;

    static {
        AUDIO_MIME_TYPES.add("wav");
        IMAGE_MIME_TYPES = new HashSet<String>();
        IMAGE_MIME_TYPES.add("gif");
        IMAGE_MIME_TYPES.add("png");
        IMAGE_MIME_TYPES.add("jpg");
        IMAGE_MIME_TYPES.add("jpeg");
        BITMAP_MIME_TYPES = new HashSet<String>();
        BITMAP_MIME_TYPES.add("bmp");
        BITMAP_MIME_TYPES.add("bitmap");
    }

    public static File getMediaLocalFile(INode node) {
        String md5 = (String)node.getProperty(MediaPropertyDescriptors.MD5);
        return new File(MediaAddon.MEDIA_HOME, md5);
    }

    /*
     * Exception decompiling
     */
    public static Collection<INodeRelation> importFiles(INode parent, Collection<File> files) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean check(Set<String> supportedTypes, String type) {
        for (String supportedType : supportedTypes) {
            if (!type.contains(supportedType)) continue;
            return true;
        }
        return false;
    }

    private static TypeDescriptor getMediaType(File file) {
        String type;
        block21: {
            try {
                type = Files.probeContentType(file.toPath());
                if (type == null) {
                    type = URLConnection.guessContentTypeFromName(file.getName());
                }
                if (type == null) {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        type = URLConnection.guessContentTypeFromStream(is);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (type == null) {
                    MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
                    type = mimeTypesMap.getContentType(file);
                }
                if (type != null) break block21;
                return null;
            }
            catch (IOException e) {
                if (Configuration.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (MediaUtils.check(BITMAP_MIME_TYPES, type)) {
            return MediaTypes.MEDIA_BITMAP;
        }
        if (MediaUtils.check(IMAGE_MIME_TYPES, type)) {
            return MediaTypes.MEDIA_IMAGE;
        }
        if (MediaUtils.check(AUDIO_MIME_TYPES, type)) {
            return MediaTypes.MEDIA_SOUND;
        }
        if (Configuration.DEBUG) {
            System.err.println("Unsupportyed type " + type);
        }
        return null;
    }

    private MediaUtils() {
    }
}

