/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.system.commands.model;

import com.centreon.studio.client.acl.ACLUser;
import com.centreon.studio.client.authentication.model.AuthenticationPropertyDescriptors;
import com.centreon.studio.client.authentication.model.object.Profile;
import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.model.node.ANode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.repository.XMLRepository;
import com.centreon.studio.client.system.commands.messages.SystemCommandMessages;
import com.centreon.studio.client.system.commands.model.ClassPropertyDescriptorAssociator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SystemCommandRepository
extends XMLRepository {
    private static final String FILE_NAME = "SystemCommandRepository.xml";
    private static final File FILE = new File(Configuration.APPLI_HOME, "SystemCommandRepository.xml");
    public static final Map<String, PropertyDescriptor<?>> MACRO_TO_PROPERTY_DESCRIPTOR = new HashMap(20);
    public static final Map<String, ClassPropertyDescriptorAssociator> MACRO_TO_DUO = new HashMap<String, ClassPropertyDescriptorAssociator>(20);
    public static final Map<String, String> MACRO_TO_SYSTEM = new HashMap<String, String>(20);

    public static void addMacro(String name, PropertyDescriptor<?> pd) {
        MACRO_TO_PROPERTY_DESCRIPTOR.put(name, pd);
    }

    private static void addContextMacro(String name, Class<? extends ANode> clazz, PropertyDescriptor<?> pd, IEclipseContext context) {
        ClassPropertyDescriptorAssociator cpda = new ClassPropertyDescriptorAssociator(pd, clazz, context);
        MACRO_TO_DUO.put(name, cpda);
    }

    private static void addSystemMacro(String name, String path) {
        MACRO_TO_SYSTEM.put(name, path);
    }

    @Inject
    public SystemCommandRepository(IEclipseContext context) {
        super(SystemCommandMessages.labelCommands, FILE, null);
        SystemCommandRepository.addMacro("%label%", AObject.LABEL);
        SystemCommandRepository.addMacro("%host.address%", PropertyDescriptors.ADDRESS);
        SystemCommandRepository.addSystemMacro("#temp#", "TEMP");
        SystemCommandRepository.addSystemMacro("#home#", "HOME");
        SystemCommandRepository.addSystemMacro("#shell#", "SHELL");
        SystemCommandRepository.addSystemMacro("#user#", "USERNAME");
        SystemCommandRepository.addContextMacro("$user.alias$", ACLUser.class, AObject.LABEL, ContextUtils.getTopContext((IEclipseContext)context));
        SystemCommandRepository.addContextMacro("$user.login$", Profile.class, AuthenticationPropertyDescriptors.LOGIN, ContextUtils.getTopContext((IEclipseContext)context));
        SystemCommandRepository.addContextMacro("$user.password$", Profile.class, AuthenticationPropertyDescriptors.PWD, ContextUtils.getTopContext((IEclipseContext)context));
    }

    @PostConstruct
    public void load() throws Exception {
        super.load();
    }

    @PreDestroy
    public void save() throws IOException {
        super.save();
    }
}

