/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.system.commands.model.ui.actions;

import com.centreon.studio.client.commons.ContextUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.model.node.ANode;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.model.ui.actions.common.ARepositoryAction;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.system.commands.messages.SystemCommandMessages;
import com.centreon.studio.client.system.commands.model.SystemCommandPropertyDescriptors;
import com.centreon.studio.client.system.commands.model.SystemCommandRepository;
import com.centreon.studio.client.system.commands.model.ui.actions.UserInput;
import com.centreon.studio.client.utils.OsUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class SystemCommandAction
extends ARepositoryAction {
    private static final String CAPTURE_KEY_WORD = "((?:#[\\d\\w\\.=]*#)|(?:%[\\d\\w\\.]*%)|(?:\\$[\\d\\w\\.=]*\\$)|(?:&[\\d\\w\\.=]*&))";
    private final String command;
    private final String args;
    private final INodeRelation relation;
    private final BrokerEventManager eventManager;
    private UserInput userInput;

    public SystemCommandAction(IRepository input, INode node, INodeRelation relation, BrokerEventManager eventManager) {
        this(node.getLabel(), input, (String)node.getProperty(SystemCommandPropertyDescriptors.PATH), (String)node.getProperty(SystemCommandPropertyDescriptors.ARGS), relation, eventManager);
    }

    private SystemCommandAction(String label, IRepository input, String path, String args, INodeRelation relation, BrokerEventManager eventManager) {
        super(label, input);
        this.args = args;
        this.command = path;
        this.relation = relation;
        this.eventManager = eventManager;
        this.userInput = new UserInput();
        Assert.isTrue((!StringUtils.isNullEmptyOrBlank((String)path) ? 1 : 0) != 0, (String)"path must not be null or empty");
    }

    public String[] getCommandLine() {
        return new String[]{this.command, this.parseArgs(this.args)};
    }

    public boolean isEnabled() {
        return this.selectionSingle();
    }

    public void setUserInput(UserInput userInput) {
        this.userInput = userInput;
    }

    protected String getImageDescriptorPath() {
        return "platform:/plugin/com.centreon.studio.client.system.commands/icons/Addons.png";
    }

    protected IUndoHandler internalRun() {
        String parsedArgs = this.parseArgs(this.args);
        if (parsedArgs == null) {
            return null;
        }
        String[] commandLine = new String[]{this.command.trim(), parsedArgs.trim()};
        new Thread((Runnable)new CommandRunnable(commandLine), "[STUDIO] System Command Runtime Exec : '" + commandLine + "'").start();
        return null;
    }

    private boolean handleCustomMacro(String arg, Matcher m, StringBuffer result, Map<String, String> tmpVariables) {
        String cleanArg;
        String key = cleanArg = arg.replaceAll("&", "");
        String defaultValue = cleanArg;
        if (cleanArg.contains("=")) {
            defaultValue = cleanArg.split("=")[1];
            key = cleanArg.split("=")[0];
        }
        if (!tmpVariables.containsKey(cleanArg)) {
            String input = this.userInput.getUserInput(key, defaultValue);
            tmpVariables.put(key, input);
            m.appendReplacement(result, input);
        } else {
            m.appendReplacement(result, tmpVariables.get(key));
        }
        return true;
    }

    private String parseArgs(String args) {
        StringBuffer result = new StringBuffer();
        HashMap<String, String> tmpVariables = new HashMap<String, String>(5);
        Pattern p = Pattern.compile(CAPTURE_KEY_WORD);
        Matcher m = p.matcher(args);
        while (m.find()) {
            String arg = m.group();
            if (arg.startsWith("$")) {
                Class<? extends ANode> clazz = SystemCommandRepository.MACRO_TO_DUO.get(arg).getClazz();
                PropertyDescriptor<?> pd = SystemCommandRepository.MACRO_TO_DUO.get(arg).getPropertyDescriptor();
                IEclipseContext context = SystemCommandRepository.MACRO_TO_DUO.get(arg).getContext();
                INode node = (INode)ContextUtils.find((IEclipseContext)context, clazz);
                if (pd != null && node != null) {
                    tmpVariables.put(arg, node.getProperty(pd).toString());
                    m.appendReplacement(result, node.getProperty(pd).toString());
                    continue;
                }
                tmpVariables.put(arg, arg);
                m.appendReplacement(result, arg);
                continue;
            }
            if (arg.startsWith("#")) {
                String sysValue = System.getenv(SystemCommandRepository.MACRO_TO_SYSTEM.get(arg));
                if (sysValue != null) {
                    tmpVariables.put(arg, sysValue);
                    m.appendReplacement(result, sysValue);
                    continue;
                }
                tmpVariables.put(arg, arg);
                m.appendReplacement(result, arg);
                continue;
            }
            if (arg.startsWith("%")) {
                PropertyDescriptor<?> pd = SystemCommandRepository.MACRO_TO_PROPERTY_DESCRIPTOR.get(arg);
                if (pd != null) {
                    tmpVariables.put(arg, this.relation.getTarget().getProperty(pd).toString());
                    m.appendReplacement(result, this.relation.getTarget().getProperty(pd).toString());
                    continue;
                }
                tmpVariables.put(arg, arg);
                m.appendReplacement(result, arg);
                continue;
            }
            if (!arg.startsWith("&") || this.handleCustomMacro(arg, m, result, tmpVariables)) continue;
            return null;
        }
        m.appendTail(result);
        return result.toString();
    }

    private class CommandRunnable
    implements Runnable {
        private final String[] commandLine;

        private CommandRunnable(String[] commandLine) {
            this.commandLine = commandLine;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Process p;
                if (OsUtils.isWindows()) {
                    String windowsCommandLine = this.commandLine[0];
                    if (this.commandLine.length > 1) {
                        windowsCommandLine = String.valueOf(windowsCommandLine) + " " + this.commandLine[1];
                    }
                    p = Runtime.getRuntime().exec(windowsCommandLine);
                } else {
                    p = Runtime.getRuntime().exec(this.commandLine);
                }
                int waitResult = 0;
                waitResult = p.waitFor();
                if (p.exitValue() == 0) return;
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    InputStream error = p.getErrorStream();
                    try {
                        block25: {
                            InputStreamReader isrerror = new InputStreamReader(error, "UTF-8");
                            try {
                                try (BufferedReader bre = new BufferedReader(isrerror);){
                                    StringBuilder sb = new StringBuilder();
                                    sb.append(SystemCommandMessages.returnCode);
                                    sb.append(": ");
                                    sb.append(waitResult);
                                    sb.append(". ");
                                    String line = null;
                                    while (true) {
                                        if ((line = bre.readLine()) == null) {
                                            SystemCommandAction.this.eventManager.async((StudioEvent)LogEvent.error(SystemCommandAction.class, (String)sb.toString(), (Object[])new Object[0]));
                                            SystemCommandAction.this.eventManager.async((StudioEvent)new PopUpEvent().setTexts(SystemCommandMessages.errorExecuteCommand, sb.toString()));
                                            break;
                                        }
                                        sb.append(line);
                                    }
                                }
                                if (isrerror == null) break block25;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (isrerror == null) throw throwable;
                                isrerror.close();
                                throw throwable;
                            }
                            isrerror.close();
                        }
                        if (error == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (error == null) throw throwable;
                        error.close();
                        throw throwable;
                    }
                    error.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException e) {
                SystemCommandAction.this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            }
        }
    }
}

