/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench;

import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.MoveShellListener;
import com.centreon.studio.client.commons.swt.SWTUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class PartsHandler {
    @CanExecute
    public static boolean canExecute(EPartService service) {
        return !service.getParts().isEmpty();
    }

    @Execute
    public static void execute(final EPartService service) {
        Collection parts = service.getParts();
        final Shell shell = SWTUtils.createShellTool((int)1, (boolean)true, (boolean)false, (boolean)true, (int)5, (boolean)true);
        final ArrayList<Button> button = new ArrayList<Button>(parts.size());
        for (MPart part : parts) {
            if (part.getTags().contains("removeOnHide")) continue;
            Button check = SWTUtils.createButtonCheck((Composite)shell, (String)part.getLocalizedLabel());
            check.setSelection(part.isToBeRendered());
            check.setData((Object)part);
            button.add(check);
        }
        Composite composite = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)true, (int)0, (int)0);
        SWTUtils.createButtonDefault((Composite)composite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordOk, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button check : button) {
                    MPart part = (MPart)check.getData();
                    if (check.getSelection()) {
                        service.activate(part);
                        continue;
                    }
                    service.hidePart(part);
                }
                shell.close();
            }
        });
        SWTUtils.createButtonPush((Composite)composite, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordCancel, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.close();
            }
        });
        new MoveShellListener(shell);
        Point size = shell.computeSize(-1, -1);
        Point pt = SWTUtils.getDisplay().getCursorLocation();
        shell.setBounds(pt.x, pt.y, size.x, size.y);
        shell.open();
    }
}

