/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench;

import com.centreon.studio.client.commons.Scheduler;
import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.impl.IntegerTextField;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.MoveShellListener;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public final class PartsRotationHandler {
    private static final String PART = "part";
    private static final String ROTATE = "rotate";
    private static final long DELAY = 1000L;
    private static int cpt = 0;
    private static int delay = 30;
    private static ScheduledFuture<?> future;

    @CanExecute
    public static boolean canExecute(MApplication application, EModelService service) {
        MWindow window = (MWindow)application.getSelectedElement();
        MPerspective perspective = service.getActivePerspective(window);
        List partStacks = service.findElements((MUIElement)perspective, null, MPartStack.class, null);
        for (MPartStack partStack : partStacks) {
            List stackElements = partStack.getChildren();
            int number = 0;
            for (MStackElement stackElement : stackElements) {
                if (!(stackElement instanceof MPart) || !stackElement.isToBeRendered()) continue;
                ++number;
            }
            if (number <= true) continue;
            return true;
        }
        return false;
    }

    @Execute
    public static void execute(final MApplication application, final EModelService service, final Scheduler scheduler) {
        MWindow window = (MWindow)application.getSelectedElement();
        MPerspective perspective = service.getActivePerspective(window);
        List partStacks = service.findElements((MUIElement)perspective, null, MPartStack.class, null);
        final Shell shell = SWTUtils.createShellTool((int)1, (boolean)true, (boolean)false, (boolean)true, (int)5, (boolean)true);
        final ArrayList<Button> checks = new ArrayList<Button>(partStacks.size());
        for (MPartStack partStack : partStacks) {
            List stackElements = partStack.getChildren();
            int number = 0;
            for (MStackElement stackElement : stackElements) {
                if (!(stackElement instanceof MPart) || !stackElement.isToBeRendered()) continue;
                ++number;
            }
            if (number < 2) continue;
            SWTUtils.createLabel((Composite)shell, (String)StringUtils.firstNotNullEmptyOrBlank((String[])new String[]{partStack.getAccessibilityPhrase(), "Part Stack"}), (int)1, (int)0x1000000, (int)-1, (int)-1);
            for (MStackElement stackElement : stackElements) {
                if (!(stackElement instanceof MPart) || !stackElement.isToBeRendered()) continue;
                MPart part = (MPart)stackElement;
                Button check = SWTUtils.createButtonCheck((Composite)shell, (String)part.getLocalizedLabel());
                check.setSelection(part.getProperties().get(ROTATE) != null);
                check.setData(PART, (Object)part);
                checks.add(check);
            }
        }
        Composite delayParent = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)false, (int)0, (int)10);
        final IntegerTextField delayField = new IntegerTextField(SWTUtils.createText((Composite)delayParent), CommonsMessages.keywordDelay, Integer.valueOf(delay), null, ControlValidators.INT_POSITIVE_VALIDATOR);
        Composite buttonParent = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)true, (int)0, (int)0);
        SWTUtils.createButtonDefault((Composite)buttonParent, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordStart, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Button check : checks) {
                    MPart part = (MPart)check.getData(PartsRotationHandler.PART);
                    if (check.getSelection()) {
                        part.getProperties().put(PartsRotationHandler.ROTATE, Boolean.TRUE.toString());
                        continue;
                    }
                    part.getProperties().remove(PartsRotationHandler.ROTATE);
                }
                delay = delayField.getValue();
                PartsRotationHandler.start(application, service, scheduler);
                shell.close();
            }
        }).setEnabled(future == null);
        SWTUtils.createButtonPush((Composite)buttonParent, (int)0x1000008, (int)0x1000000, (String)CommonsMessages.keywordStop, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartsRotationHandler.stop();
                shell.close();
            }
        }).setEnabled(future != null);
        new MoveShellListener(shell);
        Point size = shell.computeSize(-1, -1);
        Point pt = SWTUtils.getDisplay().getCursorLocation();
        shell.setBounds(pt.x, pt.y, size.x, size.y);
        shell.open();
    }

    private static Collection<MPart> getChildrenToRotate(MPartStack partStack) {
        List children = partStack.getChildren();
        ArrayList<MPart> parts = new ArrayList<MPart>(children.size());
        for (MStackElement child : children) {
            if (!(child instanceof MPart) || ((MPart)child).getProperties().get(ROTATE) == null) continue;
            parts.add((MPart)child);
        }
        return parts;
    }

    private static void rotate(MApplication application, EModelService service) {
        MWindow window = (MWindow)application.getSelectedElement();
        MPerspective perspective = service.getActivePerspective(window);
        List partStacks = service.findElements((MUIElement)perspective, null, MPartStack.class, null);
        for (MPartStack partStack : partStacks) {
            Collection<MPart> stackElements = PartsRotationHandler.getChildrenToRotate(partStack);
            int stackCpt = 0;
            for (MPart part : stackElements) {
                if (stackCpt == cpt % stackElements.size()) {
                    service.bringToTop((MUIElement)part);
                }
                ++stackCpt;
            }
        }
        if (++cpt == Integer.MAX_VALUE) {
            cpt = 0;
        }
    }

    private static void start(final MApplication application, final EModelService service, Scheduler scheduler) {
        PartsRotationHandler.stop();
        future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PartsRotationHandler.rotate(application, service);
            }
        }, 0L, 1000L * (long)delay, TimeUnit.MILLISECONDS);
    }

    private static void stop() {
        if (future != null) {
            future.cancel(false);
            future = null;
        }
    }

    static /* synthetic */ int access$0() {
        return delay;
    }
}

