/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEvent;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.workbench.CloseEditorPartsHandler;
import com.centreon.studio.client.workbench.messages.StudioWorkbenchMessages;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class WorkbenchAddon
extends AuthenticationEventHandler {
    private EPartService service;

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager, EPartService service) {
        this.service = service;
        eventManager.subscribe("studio/authentication", false, (StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Workbench addon loaded", (Object[])new Object[0]));
    }

    @Inject
    @Optional
    public void register(@Active MWindow window, final IEclipseContext context) {
        if (window != null) {
            window.getContext().set(IWindowCloseHandler.class, (Object)new IWindowCloseHandler(){

                public boolean close(MWindow window) {
                    BrokerEventManager eventManager = (BrokerEventManager)ContextInjectionFactory.make(BrokerEventManager.class, (IEclipseContext)context);
                    if (!MessageDialog.openConfirm((Shell)SWTUtils.getDisplay().getActiveShell(), (String)"Confirmation", (String)StudioWorkbenchMessages.exitConfirmationMessage)) {
                        return false;
                    }
                    eventManager.sync((StudioEvent)new AuthenticationEvent(AuthenticationEvent.Type.DO_QUIT));
                    return true;
                }
            });
        }
    }

    protected void forcedLogout() {
        CloseEditorPartsHandler.execute(this.service);
    }

    @PreDestroy
    protected void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Workbench addon destroyed", (Object[])new Object[0]));
    }

    protected void requestLogout() {
        CloseEditorPartsHandler.execute(this.service);
    }
}

