/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class AboutData {
    private final String providerName;
    private final String name;
    private final String version;
    private final String id;
    private String versionedId = null;

    public static void sortById(boolean reverse, AboutData[] infos) {
        if (reverse) {
            AboutData.reverse(infos);
            return;
        }
        Arrays.sort(infos, new Comparator<AboutData>(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            @Override
            public int compare(AboutData info1, AboutData info2) {
                String id2;
                String id1 = info1.getId();
                if (!id1.equals(id2 = info2.getId())) {
                    return this.collator.compare(id1, id2);
                }
                return this.collator.compare(info1.getName(), info2.getName());
            }
        });
    }

    protected static ImageDescriptor getImage(URL url) {
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    protected static URL getURL(String value) {
        try {
            if (value != null) {
                return new URL(value);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static void reverse(AboutData[] infos) {
        List<AboutData> infoList = Arrays.asList(infos);
        Collections.reverse(infoList);
        int i = 0;
        while (i < infos.length) {
            infos[i] = infoList.get(i);
            ++i;
        }
    }

    protected AboutData(String providerName, String name, String version, String id) {
        this.providerName = providerName == null ? "" : providerName;
        this.name = name == null ? "" : name;
        this.version = version == null ? "" : version;
        this.id = id == null ? "" : id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionedId() {
        if (this.versionedId == null) {
            this.versionedId = String.valueOf(this.getId()) + "_" + this.getVersion();
        }
        return this.versionedId;
    }
}

