/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.application.messages.ApplicationMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.update.StudioVersion;
import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.about.AboutBundleGroupData;
import com.centreon.studio.client.workbench.about.AboutItem;
import com.centreon.studio.client.workbench.about.AboutTextManager;
import com.centreon.studio.client.workbench.about.BrandingProperties;
import com.centreon.studio.client.workbench.about.InstallationDialog;
import com.centreon.studio.client.workbench.about.ProductProperties;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import com.centreon.studio.client.workbench.messages.StudioWorkbenchMessages;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends TrayDialog {
    private static final String CENTREON_WEBSITE = "https://www.centreon.com";
    private static final String DOCUMENTATION_WEBSITE = "https://documentation.centreon.com/docs/centreon-map-4/en/latest/";
    private static final String PATTERN = "yyyy-MM-dd - HH:mm:ss";
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int DETAILS_ID = 1025;
    private static final int SHELL_WIDTH = 500;
    private static final int SHELL_HEIGHT = 500;
    private final List<Image> images = new ArrayList<Image>();
    private final IEclipseContext context;
    private final IProduct product;
    private AboutTextManager aboutTextManager;
    private final String productName = "Centreon MAP";
    private StyledText text;

    public AboutDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
        this.product = Platform.getProduct();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> groups = new LinkedList<AboutBundleGroupData>();
        if (providers != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    groups.add(new AboutBundleGroupData(bundleGroup));
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InstallationDialog dialog = new InstallationDialog(AboutDialog.this.getShell(), AboutDialog.this.context);
                        dialog.open();
                    }
                });
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public boolean close() {
        int i = 0;
        while (i < this.images.size()) {
            Image image = this.images.get(i);
            image.dispose();
            ++i;
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(500, 500);
        newShell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)"Centreon MAP"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1025, WorkbenchMessages.AboutDialog_DetailsButton, false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        b.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Image aboutImage = null;
        AboutItem item = null;
        if (this.product != null) {
            String imagePath = ProductProperties.getAboutImagePath(this.product);
            if (imagePath != null) {
                aboutImage = SWTUtils.getImageFromUrl((String)imagePath);
            }
            URL centreonUrl = BrandingProperties.getUrl(CENTREON_WEBSITE, null);
            URL documentationUrl = BrandingProperties.getUrl(DOCUMENTATION_WEBSITE, null);
            if (aboutImage == null || aboutImage.getBounds().width <= 250) {
                String totalText = String.valueOf(ApplicationMessages.aboutHeader) + documentationUrl + StringUtils.NEW_LINE + StringUtils.NEW_LINE + ApplicationMessages.aboutFooter + StringUtils.NEW_LINE + StringUtils.NEW_LINE + centreonUrl + StringUtils.NEW_LINE + StringUtils.NEW_LINE + "Client version : " + new StudioVersion(Activator.getContext().getBundle().getVersion()).getFullVersion() + StringUtils.NEW_LINE + "Server version : " + System.getProperty("serverVersion");
                String licenseStartDateString = System.getProperty("license.start.date");
                String licenseEndDateString = System.getProperty("license.end.date");
                if (!StringUtils.isNullEmptyOrBlank((String)licenseStartDateString)) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(PATTERN).withLocale(Locale.FRENCH).withZone(ZoneId.systemDefault());
                    LocalDate localStartDate = LocalDate.parse(licenseStartDateString, formatter);
                    LocalDate localEndDate = LocalDate.parse(licenseEndDateString, formatter);
                    totalText = String.valueOf(totalText) + StringUtils.NEW_LINE + StudioWorkbenchMessages.licenseStartDate + " : " + localStartDate + StringUtils.NEW_LINE + StudioWorkbenchMessages.licenseEndDate + " : " + localEndDate;
                }
                item = AboutTextManager.scan(totalText);
            }
            if (aboutImage != null) {
                this.images.add(aboutImage);
            }
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = aboutImage == null || item == null ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GC gc = new GC((Drawable)parent);
        int topContainerHeightHint = 100;
        try {
            topContainerHeightHint = Math.max(topContainerHeightHint, gc.getFontMetrics().getHeight() * 6);
        }
        finally {
            gc.dispose();
        }
        if (aboutImage != null) {
            Label imageLabel = new Label(topContainer, 0);
            imageLabel.setBackground(background);
            imageLabel.setForeground(foreground);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 1;
            data.grabExcessHorizontalSpace = false;
            imageLabel.setLayoutData((Object)data);
            imageLabel.setImage(aboutImage);
            topContainerHeightHint = Math.max(topContainerHeightHint, aboutImage.getBounds().height);
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = topContainerHeightHint;
        topContainer.setLayoutData((Object)data);
        if (item != null) {
            final ScrolledComposite scroller = new ScrolledComposite(topContainer, 768);
            data = new GridData(1808);
            data.widthHint = 400;
            data.heightHint = 400;
            scroller.setLayoutData((Object)data);
            final Composite textComposite = new Composite((Composite)scroller, 0);
            textComposite.setBackground(background);
            layout = new GridLayout();
            textComposite.setLayout((Layout)layout);
            this.text = new StyledText(textComposite, 74);
            this.text.setFont(parent.getFont());
            this.text.setText(item.getText());
            this.text.setCursor(null);
            this.text.setBackground(background);
            this.text.setForeground(foreground);
            this.aboutTextManager = new AboutTextManager(this.text);
            this.aboutTextManager.setItem(item);
            this.createTextMenu();
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.text.setLayoutData((Object)gd);
            scroller.getHorizontalBar().setIncrement(20);
            scroller.getVerticalBar().setIncrement(20);
            final boolean[] inresize = new boolean[1];
            textComposite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (inresize[0]) {
                        return;
                    }
                    inresize[0] = true;
                    textComposite.layout(true);
                    int width = textComposite.getClientArea().width;
                    Point p = textComposite.computeSize(width, -1);
                    scroller.setMinSize(400, p.y);
                    inresize[0] = false;
                }
            });
            scroller.setExpandHorizontal(true);
            scroller.setExpandVertical(true);
            Point p = textComposite.computeSize(400, -1);
            textComposite.setSize(p.x, p.y);
            scroller.setMinWidth(400);
            scroller.setMinHeight(p.y);
            scroller.setContent((Control)textComposite);
        }
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        bottom.setLayoutData((Object)data);
        bar = new Label(bottom, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        return workArea;
    }

    private void createTextMenu() {
        final MenuManager textManager = new MenuManager();
        this.text.setMenu(textManager.createContextMenu((Control)this.text));
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textManager.dispose();
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }
}

