/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.workbench.about.AboutUtils;
import com.centreon.studio.client.workbench.about.ConfigurationInfo;
import com.centreon.studio.client.workbench.about.ProductInfoPage;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public final class AboutSystemPage
extends ProductInfoPage {
    private static final String ID = "productInfo.system";
    private static final int BROWSE_ERROR_LOG_BUTTON = 1024;
    private static final int COPY_TO_CLIPBOARD_BUTTON = 1025;
    private Text text;

    private static void fetchConfigurationInfo(final Text text) {
        text.setText(WorkbenchMessages.AboutSystemPage_RetrievingSystemInfo);
        Job job = Job.create((String)WorkbenchMessages.AboutSystemPage_FetchJobTitle, (IJobFunction)new IJobFunction(){

            public IStatus run(IProgressMonitor monitor) {
                final String info = ConfigurationInfo.getSystemSummary();
                if (!text.isDisposed()) {
                    text.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!text.isDisposed()) {
                                text.setText(info);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        });
        job.schedule();
    }

    public void copyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.text.getShell().getDisplay());
            String contents = this.text.getSelectionText();
            if (contents.length() == 0) {
                contents = this.text.getText();
            }
            clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    public void createControl(Composite parent) {
        Composite outer = this.createOuterComposite(parent);
        this.text = new Text(outer, 527114);
        this.text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.text.setLayoutData((Object)gridData);
        this.text.setFont(JFaceResources.getTextFont());
        AboutSystemPage.fetchConfigurationInfo(this.text);
        this.setControl((Control)outer);
    }

    @Override
    public void createPageButtons(Composite parent) {
        Button button = this.createButton(parent, 1024, WorkbenchMessages.AboutSystemDialog_browseErrorLogName);
        String filename = Platform.getLogFileLocation().toOSString();
        button.setEnabled(new File(filename).exists());
        this.createButton(parent, 1025, WorkbenchMessages.AboutSystemDialog_copyToClipboardName);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.openErrorLogBrowser();
                break;
            }
            case 1025: {
                this.runCopyToClipboard();
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    String getId() {
        return ID;
    }

    private void openErrorLogBrowser() {
        AboutUtils.openErrorLogBrowser(this.getShell());
    }

    private void runCopyToClipboard() {
        if (this.text == null) {
            return;
        }
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.getShell().getDisplay());
            clipboard.setContents(new Object[]{this.text.getText()}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }
}

