/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.about.AboutBundleData;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BundleSigningInfo {
    private Composite composite;
    private StyledText certificate;
    private Text date;
    private AboutBundleData data;

    private static Properties parseCert(String certString) {
        StringTokenizer toker = new StringTokenizer(certString, ",");
        Properties cert = new Properties();
        while (toker.hasMoreTokens()) {
            String pair = toker.nextToken();
            int idx = pair.indexOf(61);
            if (idx <= 0 || idx >= pair.length() - 2) continue;
            String key = pair.substring(0, idx).trim();
            String value = pair.substring(idx + 1).trim();
            if (value.length() > 2) {
                if (value.charAt(0) == '\"') {
                    value = value.substring(1);
                }
                if (value.charAt(value.length() - 1) == '\"') {
                    value = value.substring(0, value.length() - 1);
                }
            }
            cert.setProperty(key, value);
        }
        return cert;
    }

    private static Properties[] parseCerts(Certificate[] chain) {
        ArrayList<Properties> certs = new ArrayList<Properties>(chain.length);
        int i = 0;
        while (i < chain.length) {
            Properties cert;
            if (chain[i] instanceof X509Certificate && (cert = BundleSigningInfo.parseCert(((X509Certificate)chain[i]).getSubjectDN().getName())) != null) {
                certs.add(cert);
            }
            ++i;
        }
        return certs.toArray(new Properties[certs.size()]);
    }

    public Control createContents(Composite parent) {
        this.composite = new Composite(parent, 2048);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        Label dateLabel = new Label(this.composite, 0);
        dateLabel.setText(WorkbenchMessages.BundleSigningTray_Signing_Date);
        GridData dateGridData = new GridData(4, 1, true, false);
        this.date = new Text(this.composite, 8);
        GC gc = new GC((Drawable)this.date);
        gc.setFont(JFaceResources.getDialogFont());
        Point size = gc.stringExtent(DateFormat.getDateTimeInstance().format(new Date()));
        dateGridData.widthHint = size.x;
        gc.dispose();
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setLayoutData((Object)dateGridData);
        Label signerLabel = new Label(this.composite, 0);
        signerLabel.setText(WorkbenchMessages.BundleSigningTray_Signing_Certificate);
        GridData signerGridData = new GridData(1, 1, true, false);
        signerGridData.horizontalSpan = 2;
        signerGridData = new GridData(4, 4, true, true);
        signerGridData.horizontalSpan = 2;
        this.certificate = new StyledText(this.composite, 74);
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.certificate.setLayoutData((Object)signerGridData);
        Dialog.applyDialogFont((Control)this.composite);
        this.startJobs();
        return this.composite;
    }

    public void dispose() {
        this.composite.dispose();
    }

    public void setData(AboutBundleData data) {
        this.data = data;
        this.startJobs();
    }

    private boolean isOpen() {
        return this.certificate != null && !this.certificate.isDisposed();
    }

    private void startJobs() {
        if (!this.isOpen()) {
            return;
        }
        this.certificate.setText(WorkbenchMessages.BundleSigningTray_Working);
        this.date.setText(WorkbenchMessages.BundleSigningTray_Working);
        final BundleContext bundleContext = Activator.getContext();
        final ServiceReference factoryRef = bundleContext.getServiceReference(SignedContentFactory.class.getName());
        if (factoryRef == null) {
            System.err.println(WorkbenchMessages.BundleSigningTray_Cant_Find_Service);
            return;
        }
        final SignedContentFactory contentFactory = (SignedContentFactory)bundleContext.getService(factoryRef);
        if (contentFactory == null) {
            System.err.println(WorkbenchMessages.BundleSigningTray_Cant_Find_Service);
            return;
        }
        final AboutBundleData myData = this.data;
        final Job signerJob = new Job(NLS.bind((String)WorkbenchMessages.BundleSigningTray_Determine_Signer_For, (Object)myData.getId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String dateText;
                    String signerText;
                    if (!myData.equals(BundleSigningInfo.this.data)) {
                        return Status.OK_STATUS;
                    }
                    SignedContent signedContent = contentFactory.getSignedContent(myData.getBundle());
                    if (!myData.equals(BundleSigningInfo.this.data)) {
                        return Status.OK_STATUS;
                    }
                    SignerInfo[] signers = signedContent.getSignerInfos();
                    if (!BundleSigningInfo.this.isOpen() && myData.equals(BundleSigningInfo.this.data)) {
                        return Status.OK_STATUS;
                    }
                    if (signers.length == 0) {
                        signerText = WorkbenchMessages.BundleSigningTray_Unsigned;
                        dateText = WorkbenchMessages.BundleSigningTray_Unsigned;
                    } else {
                        Properties[] certs = BundleSigningInfo.parseCerts(signers[0].getCertificateChain());
                        if (certs.length == 0) {
                            signerText = WorkbenchMessages.BundleSigningTray_Unknown;
                        } else {
                            StringBuffer buffer = new StringBuffer();
                            Iterator<Map.Entry<Object, Object>> i = certs[0].entrySet().iterator();
                            while (i.hasNext()) {
                                Map.Entry<Object, Object> entry = i.next();
                                buffer.append(entry.getKey());
                                buffer.append('=');
                                buffer.append(entry.getValue());
                                if (!i.hasNext()) continue;
                                buffer.append('\n');
                            }
                            signerText = buffer.toString();
                        }
                        Date signDate = signedContent.getSigningTime(signers[0]);
                        dateText = signDate != null ? DateFormat.getDateTimeInstance().format(signDate) : WorkbenchMessages.BundleSigningTray_Unknown;
                    }
                    SWTUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!BundleSigningInfo.this.isOpen() && !myData.equals(BundleSigningInfo.this.data)) {
                                return;
                            }
                            BundleSigningInfo.this.certificate.setText(signerText);
                            BundleSigningInfo.this.date.setText(dateText);
                        }
                    });
                }
                catch (IOException e) {
                    return new Status(4, Activator.getContext().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    return new Status(4, Activator.getContext().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        signerJob.setSystem(true);
        signerJob.belongsTo((Object)signerJob);
        signerJob.schedule();
        Job cleanup = new Job(WorkbenchMessages.BundleSigningTray_Unget_Signing_Service){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Job.getJobManager().join((Object)signerJob, monitor);
                }
                catch (OperationCanceledException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                bundleContext.ungetService(factoryRef);
                return Status.OK_STATUS;
            }
        };
        cleanup.setSystem(true);
        cleanup.schedule();
    }
}

