/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.workbench.about.ISystemSummarySection;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public final class ConfigurationInfo {
    private static final String SECTION_TITLE = "sectionTitle";
    private static String PL_SYSTEM_SUMMARY_SECTIONS = "systemSummarySections";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSystemSummary() {
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try {
                StringWriter out = new StringWriter();
                try {
                    String string;
                    block16: {
                        PrintWriter writer = new PrintWriter(out);
                        try {
                            writer.println(NLS.bind((String)WorkbenchMessages.SystemSummary_timeStamp, (Object)DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date())));
                            ConfigurationInfo.appendExtensions(writer);
                            writer.close();
                            string = out.toString();
                            return string;
                        }
                        finally {
                            if (writer == null) break block16;
                            writer.close();
                        }
                    }
                    if (out != null) {
                        out.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private static void appendExtensions(PrintWriter writer) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = ConfigurationInfo.getSortedExtensions(Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", PL_SYSTEM_SUMMARY_SECTIONS));
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object obj = null;
                try {
                    String className = element.getAttribute("class");
                    String simpleClassName = className.substring(className.lastIndexOf(46));
                    String newClassName = "com.centreon.studio.client.workbench.about" + simpleClassName;
                    Class<?> clazz2 = Class.forName(newClassName);
                    obj = clazz2.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break block5;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                writer.println();
                writer.println(NLS.bind((String)WorkbenchMessages.SystemSummary_sectionTitle, (Object)element.getAttribute(SECTION_TITLE)));
                if (obj instanceof ISystemSummarySection) {
                    ISystemSummarySection logSection = obj;
                    logSection.write(writer);
                }
            }
            ++n2;
        }
    }

    private static IConfigurationElement[] getSortedExtensions(IConfigurationElement[] configElements) {
        Arrays.sort(configElements, new Comparator<IConfigurationElement>(){
            Collator collator = Collator.getInstance((Locale)Locale.getDefault());

            @Override
            public int compare(IConfigurationElement a, IConfigurationElement b) {
                String id1 = a.getAttribute("id");
                String id2 = b.getAttribute("id");
                if (id1 != null && id2 != null && !id1.equals(id2)) {
                    return this.collator.compare(id1, id2);
                }
                String title1 = a.getAttribute(ConfigurationInfo.SECTION_TITLE);
                String title2 = b.getAttribute(ConfigurationInfo.SECTION_TITLE);
                if (title1 == null) {
                    title1 = "";
                }
                if (title2 == null) {
                    title2 = "";
                }
                return this.collator.compare(title1, title2);
            }
        });
        return configElements;
    }

    private ConfigurationInfo() {
    }
}

