/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.about.AboutBundleData;
import com.centreon.studio.client.workbench.about.AboutData;
import com.centreon.studio.client.workbench.about.ISystemSummarySection;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class ConfigurationLogDefaultSection
implements ISystemSummarySection {
    private static final String ECLIPSE_PROPERTY_PREFIX = "eclipse.";

    private static void appendProperties(PrintWriter writer) {
        writer.println();
        writer.println(WorkbenchMessages.SystemSummary_systemProperties);
        Properties properties = System.getProperties();
        TreeSet<String> set = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String s1 = o1;
                String s2 = o2;
                return s1.compareTo(s2);
            }
        });
        set.addAll(properties.stringPropertyNames());
        for (String key : set) {
            String value = properties.getProperty(key);
            writer.print(key);
            writer.print('=');
            if (key.startsWith(ECLIPSE_PROPERTY_PREFIX)) {
                ConfigurationLogDefaultSection.printEclipseProperty(writer, value);
                continue;
            }
            if (key.toUpperCase().indexOf("PASSWORD") != -1) {
                int j = 0;
                while (j < value.length()) {
                    writer.print('*');
                    ++j;
                }
                writer.println();
                continue;
            }
            writer.println(value);
        }
    }

    private static void appendRegistry(PrintWriter writer) {
        writer.println();
        writer.println(WorkbenchMessages.SystemSummary_pluginRegistry);
        Bundle[] bundles = Activator.getContext().getBundles();
        AboutData[] bundleInfos = new AboutBundleData[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            bundleInfos[i] = new AboutBundleData(bundles[i]);
            ++i;
        }
        AboutData.sortById(false, bundleInfos);
        AboutData[] aboutDataArray = bundleInfos;
        int n = bundleInfos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutData info = aboutDataArray[n2];
            Object[] args = new String[]{info.getId(), info.getVersion(), info.getName(), ((AboutBundleData)info).getStateName()};
            writer.println(NLS.bind((String)WorkbenchMessages.SystemSummary_descriptorIdVersionState, (Object[])args));
            ++n2;
        }
    }

    private static String[] getArrayFromList(String prop, String separator) {
        if (prop == null || "".equals(prop.trim())) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(prop, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if ("".equals(token)) continue;
            list.add(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private static void printEclipseProperty(PrintWriter writer, String value) {
        String[] lines;
        String[] stringArray = lines = ConfigurationLogDefaultSection.getArrayFromList(value, "\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            writer.println(line);
            ++n2;
        }
    }

    @Override
    public void write(PrintWriter writer) {
        ConfigurationLogDefaultSection.appendProperties(writer);
        ConfigurationLogDefaultSection.appendRegistry(writer);
    }
}

