/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.workbench.about.IInstallationPageContainer;
import com.centreon.studio.client.workbench.about.InstallationPage;
import com.centreon.studio.client.workbench.about.WorkbenchMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class InstallationDialog
extends TrayDialog
implements IInstallationPageContainer {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    protected static final String ID = "ID";
    private static final String DIALOG_SETTINGS_SECTION = "InstallationDialogSettings";
    private static final int TAB_WIDTH_IN_DLUS = 440;
    private static final int TAB_HEIGHT_IN_DLUS = 320;
    private static String lastSelectedTabId;
    private final Map<InstallationPage, String> pageToId = new HashMap<InstallationPage, String>();
    private final IEclipseContext context;
    private TabFolder folder;
    private ButtonManager buttonManager;

    private static void rememberSelectedTab(String pageId) {
        lastSelectedTabId = pageId;
    }

    public InstallationDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
    }

    @Override
    public void registerPageButton(InstallationPage page, Button button) {
        this.buttonManager.addPageButton(this.pageToId(page), button);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.okPressed();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String productName = "";
        IProduct product = Platform.getProduct();
        if (product != null && product.getName() != null) {
            productName = product.getName();
        }
        newShell.setText(NLS.bind((String)WorkbenchMessages.InstallationDialog_ShellTitle, (Object)productName));
    }

    protected void createButtons(InstallationPage page) {
        page.createPageButtons(this.buttonManager.getParent());
        Dialog.applyDialogFont((Control)this.buttonManager.getParent());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.makeColumnsEqualWidth = false;
        this.buttonManager = new ButtonManager(parent);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        boolean selected = false;
        if (this.folder.getItemCount() > 0) {
            if (lastSelectedTabId != null) {
                TabItem[] items = this.folder.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getData(ID).equals(lastSelectedTabId)) {
                        this.folder.setSelection(i);
                        this.tabSelected(items[i]);
                        selected = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!selected) {
                this.tabSelected(this.folder.getItem(0));
            }
        }
        Dialog.applyDialogFont((Control)this.folder);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.folder = new TabFolder(composite, 0);
        this.createFolderItems(this.folder);
        GridData folderData = new GridData(4, 4, true, true);
        folderData.widthHint = this.convertHorizontalDLUsToPixels(440);
        folderData.heightHint = this.convertVerticalDLUsToPixels(320);
        this.folder.setLayoutData((Object)folderData);
        this.folder.addSelectionListener((SelectionListener)this.createFolderSelectionListener());
        this.folder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                InstallationDialog.this.releaseContributions();
            }
        });
        return composite;
    }

    protected void createFolderItems(TabFolder folder) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = (IExtensionRegistry)this.context.get(IExtensionRegistry.class);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "installationPages");
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(point.getUniqueIdentifier());
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String className = element.getAttribute(ATT_CLASS);
            String simpleClassName = className.substring(className.lastIndexOf(46));
            String newClassName = String.valueOf(this.getClass().getPackage().getName()) + simpleClassName;
            try {
                Class.forName(newClassName);
                TabItem item = new TabItem(folder, 0);
                item.setData(ID, (Object)element.getAttribute(ATT_ID));
                item.setText(element.getAttribute(ATT_NAME));
                item.setData((Object)element);
                Composite control = new Composite((Composite)folder, 0);
                control.setLayout((Layout)new GridLayout());
                item.setControl((Control)control);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++n2;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        DialogSettings settings = new DialogSettings("Workbench");
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    protected boolean isResizable() {
        return true;
    }

    protected String pageToId(InstallationPage page) {
        String pageId = this.pageToId.get((Object)page);
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        return pageId;
    }

    private SelectionAdapter createFolderSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallationDialog.this.tabSelected((TabItem)e.item);
            }
        };
    }

    private void releaseContributions() {
        this.buttonManager.clear();
    }

    private void tabSelected(TabItem item) {
        if (item.getData() instanceof IConfigurationElement) {
            IConfigurationElement element = (IConfigurationElement)item.getData();
            Composite pageComposite = (Composite)item.getControl();
            try {
                String className = element.getAttribute(ATT_CLASS);
                String simpleClassName = className.substring(className.lastIndexOf(46));
                String newClassName = String.valueOf(this.getClass().getPackage().getName()) + simpleClassName;
                Class<?> clazz = Class.forName(newClassName);
                final InstallationPage page = (InstallationPage)((Object)clazz.newInstance());
                page.createControl(pageComposite);
                Dialog.applyDialogFont((Control)pageComposite);
                page.setPageContainer(this);
                this.pageToId.put(page, element.getAttribute(ATT_ID));
                this.createButtons(page);
                item.setData((Object)page);
                item.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        page.dispose();
                    }
                });
                pageComposite.layout(true, true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        String id = (String)item.getData(ID);
        InstallationDialog.rememberSelectedTab(id);
        this.buttonManager.update(id);
        Button button = this.createButton(this.buttonManager.getParent(), 12, IDialogConstants.CLOSE_LABEL, true);
        GridData gd = (GridData)button.getLayoutData();
        gd.horizontalAlignment = 1;
        gd.horizontalIndent = this.convertHorizontalDLUsToPixels(61) / 2;
        this.getButtonBar().getParent().layout(true, true);
    }

    private static class ButtonManager {
        private final Composite composite;
        private Map<String, List<Button>> buttonMap = new HashMap<String, List<Button>>();

        private ButtonManager(Composite composite) {
            this.composite = composite;
        }

        public Composite getParent() {
            return this.composite;
        }

        protected void setButtonLayoutData(FontMetrics metrics, Control button, boolean visible) {
            GridData data = new GridData(256);
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)metrics, (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            data.exclude = !visible;
            button.setLayoutData((Object)data);
        }

        private void addPageButton(String id, Button button) {
            List<Button> list = this.buttonMap.get(id);
            if (list == null) {
                list = new ArrayList<Button>(1);
                this.buttonMap.put(id, list);
            }
            list.add(button);
        }

        private void clear() {
            this.buttonMap = new HashMap<String, List<Button>>();
        }

        private void update(String currentPageId) {
            if (this.composite == null || this.composite.isDisposed()) {
                return;
            }
            GC metricsGC = new GC((Drawable)this.composite);
            FontMetrics metrics = metricsGC.getFontMetrics();
            metricsGC.dispose();
            List<Button> buttons = this.buttonMap.get(currentPageId);
            Control[] children = this.composite.getChildren();
            int visibleChildren = 0;
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setVisible(false);
                this.setButtonLayoutData(metrics, control, false);
                ++n2;
            }
            if (buttons != null) {
                int i = 0;
                while (i < buttons.size()) {
                    Button button = buttons.get(i);
                    button.setVisible(true);
                    this.setButtonLayoutData(metrics, (Control)button, true);
                    GridData data = (GridData)button.getLayoutData();
                    data.exclude = false;
                    ++visibleChildren;
                    ++i;
                }
            }
            GridLayout compositeLayout = (GridLayout)this.composite.getLayout();
            compositeLayout.numColumns = visibleChildren;
            this.composite.layout(true);
        }
    }
}

