/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.about;

import com.centreon.studio.client.utils.StringUtils;
import com.centreon.studio.client.workbench.about.BrandingProperties;
import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ProductProperties
extends BrandingProperties {
    private static Map<Bundle, String[]> mappingsMap = new HashMap<Bundle, String[]>(4);

    public static String getAboutImagePath(IProduct product) {
        String aboutImage = product.getProperty("aboutImage");
        if (StringUtils.isNullEmptyOrBlank((String)aboutImage)) {
            return null;
        }
        return "platform:/plugin/" + product.getDefiningBundle().getSymbolicName() + aboutImage;
    }

    public static String getAboutText(IProduct product) {
        String property = product.getProperty("aboutText");
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        Object[] tempMappings = ProductProperties.getMappings(product.getDefiningBundle());
        int i = 0;
        while (i < tempMappings.length) {
            Object nextString = tempMappings[i];
            int length = ((String)nextString).length();
            if (length > 2 && ((String)nextString).charAt(0) == '$' && ((String)nextString).charAt(length - 1) == '$') {
                String systemPropertyKey = ((String)nextString).substring(1, length - 1);
                tempMappings[i] = System.getProperty(systemPropertyKey, "");
            }
            ++i;
        }
        return MessageFormat.format((String)property, (Object[])tempMappings);
    }

    private static String[] getMappings(Bundle definingBundle) {
        String[] mappings = mappingsMap.get(definingBundle);
        if (mappings == null) {
            mappings = ProductProperties.loadMappings(definingBundle);
        }
        if (mappings == null) {
            mappings = new String[]{};
        }
        return mappings;
    }

    private static String[] loadMappings(Bundle definingBundle) {
        PropertyResourceBundle bundle;
        block19: {
            URL location = Platform.find((Bundle)definingBundle, (IPath)new Path("$nl$/about.mappings"));
            bundle = null;
            if (location != null) {
                InputStream is = null;
                try {
                    try {
                        is = location.openStream();
                        bundle = new PropertyResourceBundle(is);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (bundle != null) {
            boolean found = true;
            int i = 0;
            while (found) {
                try {
                    mappingsList.add(bundle.getString(Integer.toString(i)));
                }
                catch (MissingResourceException missingResourceException) {
                    found = false;
                }
                ++i;
            }
        }
        String[] mappings = mappingsList.toArray(new String[mappingsList.size()]);
        mappingsMap.put(definingBundle, mappings);
        return mappings;
    }
}

