/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.action;

import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

public class TogglePartAction
extends StudioAction {
    private static final Collection<TogglePartAction> ACTIONS = new HashSet<TogglePartAction>();
    private static final IPartListener LISTENER = new IPartListener(){

        public void partActivated(MPart part) {
            TogglePartAction.update();
        }

        public void partBroughtToTop(MPart part) {
            TogglePartAction.update();
        }

        public void partDeactivated(MPart part) {
            TogglePartAction.update();
        }

        public void partHidden(MPart part) {
            TogglePartAction.update();
        }

        public void partVisible(MPart part) {
            TogglePartAction.update();
        }
    };
    private final EPartService service;
    private final MPart part;

    private static void update() {
        for (TogglePartAction action : ACTIONS) {
            action.firePropertyChange("checked", null, null);
        }
    }

    public TogglePartAction(EPartService service, String partId) {
        super("Toggle part");
        this.service = service;
        this.part = service.findPart(partId);
        service.addPartListener(LISTENER);
        ACTIONS.add(this);
    }

    public int getStyle() {
        return 2;
    }

    public String getText() {
        return String.valueOf(this.part.isToBeRendered() ? "Close " : "Open ") + this.part.getLocalizedLabel();
    }

    public boolean isChecked() {
        return this.part.isToBeRendered();
    }

    protected String getImageDescriptorPath() {
        return this.part.getIconURI();
    }

    protected IUndoHandler internalRun() {
        if (this.part.isToBeRendered()) {
            this.service.hidePart(this.part);
        } else {
            this.service.activate(this.part);
        }
        TogglePartAction.update();
        return null;
    }
}

