/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties;

import com.centreon.studio.client.workbench.properties.CellInfo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Cell
extends Canvas {
    private Image image = null;
    private int type = 1;

    public Cell(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Cell.this.paintControl(e);
            }
        });
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.getSize().x, this.getSize().y);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isButton() {
        return (this.type & 1) > 0;
    }

    public boolean isLabel() {
        return (this.type & 2) > 0;
    }

    public boolean isShadow() {
        return (this.type & 4) > 0;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setType(int type) {
        this.type = type;
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (this.type == 1) {
            gc.setForeground(Display.getCurrent().getSystemColor(1));
            gc.drawLine(0, 0, this.getSize().x - 2, 0);
            gc.drawLine(0, 1, this.getSize().x - 3, 1);
            gc.drawLine(0, 0, 0, this.getSize().y - 2);
            gc.drawLine(1, 0, 1, this.getSize().y - 3);
            gc.setForeground(Display.getCurrent().getSystemColor(16));
            gc.drawLine(2, this.getSize().y - 2, this.getSize().x - 1, this.getSize().y - 2);
            gc.drawLine(1, this.getSize().y - 1, this.getSize().x - 1, this.getSize().y - 1);
            gc.drawLine(this.getSize().x - 2, 2, this.getSize().x - 2, this.getSize().y - 1);
            gc.drawLine(this.getSize().x - 1, 1, this.getSize().x - 1, this.getSize().y - 1);
        } else {
            gc.setForeground(Display.getCurrent().getSystemColor(16));
            gc.drawLine(0, 0, this.getSize().x - 1, 0);
            gc.drawLine(0, 0, 0, this.getSize().y - 1);
            if (((CellInfo)this.getData()).isRightBorder()) {
                gc.drawLine(this.getSize().x - 1, 0, this.getSize().x - 1, this.getSize().y - 1);
            }
            if (((CellInfo)this.getData()).isDownBorder()) {
                gc.drawLine(0, this.getSize().y - 1, this.getSize().x - 1, this.getSize().y - 1);
            }
        }
        if (this.image != null) {
            gc.drawImage(this.image, (this.getSize().x - this.image.getBounds().width) / 2 + 1, (this.getSize().y - this.image.getBounds().height) / 2 + 1);
        }
    }
}

