/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.workbench.properties.Cell;
import com.centreon.studio.client.workbench.properties.CellInfo;
import com.centreon.studio.client.workbench.properties.CellListener;
import com.centreon.studio.client.workbench.properties.MainView;
import com.centreon.studio.client.workbench.properties.Preferences;
import com.centreon.studio.client.workbench.properties.ResourceManager;
import com.centreon.studio.client.workbench.properties.dialogs.NewRecordDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class Controller {
    private Composite minesField;
    private final MainView view;
    private final CellListener cellListener;
    private final Preferences preferences;
    private final Map<String, Object> records;
    private int[] mines;

    private static CellInfo getCellInfo(Cell cell) {
        return (CellInfo)cell.getData();
    }

    public Controller(MainView view, Preferences preferences, Map<String, Object> records) {
        this.view = view;
        this.records = records;
        this.preferences = preferences;
        this.cellListener = new CellListener(view);
        this.mines = new int[preferences.getMinesCount()];
    }

    public void changeMode(String mode) {
        this.preferences.setMode(mode);
    }

    public void finishGame() {
        Cell[] cells;
        this.view.getTimer().stop();
        this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("happy.gif"));
        if (this.getPreferences().isSoundEnabled()) {
            ResourceManager.INSTANCE.getSound("finish.wav").play();
        }
        Cell[] cellArray = cells = this.getAllCells();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            cell.removeMouseListener((MouseListener)this.cellListener);
            ++n2;
        }
        if (this.isTimeBetterThanRecord()) {
            this.showNewRecordDialog();
        }
    }

    public Cell[] getAllCells() {
        List<Control> cells = Arrays.asList(this.minesField.getChildren());
        return cells.toArray(new Cell[cells.size()]);
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Map<String, Object> getRecords() {
        return this.records;
    }

    public void initMinesField() {
        if (this.view.getTimer().isRunning()) {
            this.view.getTimer().stop();
            this.view.getTimer().resetRunning();
        } else {
            this.view.getTimer().resetStopped();
        }
        this.initMinesField(this.minesField);
        this.view.getMainButton().setImage(ResourceManager.INSTANCE.getImage("smile.gif"));
    }

    public void initMinesField(Composite minesField) {
        this.minesField = minesField;
        this.fillComposite();
        this.fillMines();
        this.fillWarnings();
    }

    public boolean isGameFinished() {
        Cell[] cells;
        boolean sw = true;
        Cell[] cellArray = cells = this.getAllCells();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo;
            Cell cell = cellArray[n2];
            if (cell.isButton() && !(cellInfo = Controller.getCellInfo(cell)).isMine()) {
                sw = false;
            }
            ++n2;
        }
        return sw;
    }

    public void refresh(int minesCount, int rows, int columns) {
        this.preferences.setMinesCount(minesCount);
        this.preferences.setRows(rows);
        this.preferences.setColumns(columns);
        this.mines = new int[this.preferences.getMinesCount()];
        this.view.getCounter().reset(this.preferences.getMinesCount());
        GridLayout layout = new GridLayout();
        layout.numColumns = this.preferences.getColumns();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = true;
        this.minesField.setLayout((Layout)layout);
        this.initMinesField();
    }

    public List<CellInfo> showAllCellsAround(CellInfo cellInfo) {
        ArrayList<CellInfo> list = new ArrayList<CellInfo>();
        CellInfo aux = null;
        Control[] controls = this.minesField.getChildren();
        int columns = this.preferences.getColumns();
        if (cellInfo.isTopBorder()) {
            if (cellInfo.isLeftBorder()) {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
            } else if (cellInfo.isRightBorder()) {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
            } else {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
            }
        } else if (cellInfo.isDownBorder()) {
            if (cellInfo.isLeftBorder()) {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
            } else if (cellInfo.isRightBorder()) {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
            } else {
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                list.add(aux);
                aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                list.add(aux);
            }
        } else if (cellInfo.isLeftBorder()) {
            aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
        } else if (cellInfo.isRightBorder()) {
            aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
        } else {
            aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
            list.add(aux);
            aux = (CellInfo)controls[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
            list.add(aux);
        }
        return list;
    }

    public void showAllMines() {
        Cell[] cells;
        Cell[] cellArray = cells = this.getAllCells();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            this.show(cell);
            ++n2;
        }
    }

    public void showAllZeroWarningsAround(CellInfo cellInfo, List<CellInfo> list) {
        if (list.contains(cellInfo)) {
            return;
        }
        list.add(cellInfo);
        CellInfo aux = null;
        Control[] c = this.minesField.getChildren();
        int columns = this.preferences.getColumns();
        if (cellInfo.isTopBorder()) {
            if (cellInfo.isLeftBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0 && !aux.isFlag()) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            } else if (cellInfo.isRightBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            } else {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            }
        } else if (cellInfo.isDownBorder()) {
            if (cellInfo.isLeftBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            } else if (cellInfo.isRightBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            } else {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                if (aux.getWarning() == 0) {
                    this.showAllZeroWarningsAround(aux, list);
                } else if (!list.contains(aux)) {
                    list.add(aux);
                }
            }
        } else if (cellInfo.isLeftBorder()) {
            aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
        } else if (cellInfo.isRightBorder()) {
            aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
        } else {
            aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
            aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
            if (aux.getWarning() == 0) {
                this.showAllZeroWarningsAround(aux, list);
            } else if (!list.contains(aux)) {
                list.add(aux);
            }
        }
    }

    private CellInfo createCellInfo(int i, int j) {
        CellInfo cellInfo = new CellInfo(i, j);
        if (i == 0) {
            cellInfo.setBorder(1);
        } else if (i == this.preferences.getRows() - 1) {
            cellInfo.setBorder(8);
        }
        if (j == 0) {
            cellInfo.setBorder(2);
        } else if (j == this.preferences.getColumns() - 1) {
            cellInfo.setBorder(4);
        }
        return cellInfo;
    }

    private void disposeAllCells() {
        Control[] c;
        Control[] controlArray = c = this.minesField.getChildren();
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.dispose();
            ++n2;
        }
    }

    private void fillComposite() {
        boolean isLayoutNeeded;
        if (this.mineFieldNeedsOnlyRefreshing()) {
            this.refreshAllCells();
            return;
        }
        boolean bl = isLayoutNeeded = this.minesField.getChildren().length != 0;
        if (isLayoutNeeded) {
            this.disposeAllCells();
        }
        this.initializeAllCells();
        if (isLayoutNeeded) {
            this.minesField.layout(true);
        }
    }

    private void fillMines() {
        int minesAlreadySet = 0;
        while (minesAlreadySet < this.preferences.getMinesCount()) {
            int index = (int)Math.rint(Math.random() * (double)(this.preferences.getColumns() * this.preferences.getRows() - 1));
            CellInfo cellInfo = this.getCellInfo(index);
            if (cellInfo.isMine()) continue;
            cellInfo.setMine(true);
            this.mines[minesAlreadySet] = index;
            ++minesAlreadySet;
        }
    }

    private void fillWarnings() {
        CellInfo cellInfo = null;
        CellInfo aux = null;
        int columns = this.preferences.getColumns();
        Control[] c = this.minesField.getChildren();
        int[] nArray = this.mines;
        int n = this.mines.length;
        int n2 = 0;
        while (n2 < n) {
            int mine = nArray[n2];
            cellInfo = (CellInfo)c[mine].getData();
            if (cellInfo.isTopBorder()) {
                if (cellInfo.isLeftBorder()) {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                } else if (cellInfo.isRightBorder()) {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                } else {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                }
            } else if (cellInfo.isDownBorder()) {
                if (cellInfo.isLeftBorder()) {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                } else if (cellInfo.isRightBorder()) {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                } else {
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                    aux.setWarning(aux.getWarning() + 1);
                    aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                    aux.setWarning(aux.getWarning() + 1);
                }
            } else if (cellInfo.isLeftBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
            } else if (cellInfo.isRightBorder()) {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
            } else {
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[cellInfo.getLocation().x * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x - 1) * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y - 1].getData();
                aux.setWarning(aux.getWarning() + 1);
                aux = (CellInfo)c[(cellInfo.getLocation().x + 1) * columns + cellInfo.getLocation().y + 1].getData();
                aux.setWarning(aux.getWarning() + 1);
            }
            ++n2;
        }
    }

    private CellInfo getCellInfo(int computedCoordXY) {
        return Controller.getCellInfo((Cell)this.minesField.getChildren()[computedCoordXY]);
    }

    private int getRecordTime() {
        if (this.preferences.getMode().equals("expert")) {
            return this.getRecordTime("timeExpert");
        }
        if (this.preferences.getMode().equals("intermediate")) {
            return this.getRecordTime("timeIntermediate");
        }
        if (this.preferences.getMode().equals("beginner")) {
            return this.getRecordTime("timeBeginner");
        }
        return Integer.MIN_VALUE;
    }

    private int getRecordTime(Object modeId) {
        return (Integer)this.records.get(modeId);
    }

    private void initializeAllCells() {
        int i = 0;
        while (i < this.preferences.getRows()) {
            int j = 0;
            while (j < this.preferences.getColumns()) {
                this.initializeCell(i, j);
                ++j;
            }
            ++i;
        }
    }

    private Cell initializeCell(int i, int j) {
        Cell cell = new Cell(this.minesField, 0);
        cell.setSize(this.minesField.getSize().x / this.preferences.getColumns(), this.minesField.getSize().y / this.preferences.getRows());
        cell.addMouseListener((MouseListener)this.cellListener);
        cell.setData(this.createCellInfo(i, j));
        return cell;
    }

    private boolean isTimeBetterThanRecord() {
        return this.getRecordTime() > this.view.getTimer().getTime();
    }

    private boolean mineFieldNeedsOnlyRefreshing() {
        return this.minesField.getChildren().length == this.preferences.getRows() * this.preferences.getColumns();
    }

    private void refreshAllCells() {
        Cell[] cells;
        Cell[] cellArray = cells = this.getAllCells();
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell cell = cellArray[n2];
            this.refreshCell(cell);
            ++n2;
        }
    }

    private void refreshCell(Cell cell) {
        cell.setSize(this.minesField.getSize().x / this.preferences.getColumns(), this.minesField.getSize().y / this.preferences.getRows());
        CellInfo cellInfo = Controller.getCellInfo(cell);
        if (cell.isLabel()) {
            cell.setType(1);
            cell.setImage(null);
            cell.setBackground(Display.getCurrent().getSystemColor(22));
            cell.redraw();
        }
        if (cellInfo.isFlag()) {
            cellInfo.setFlag(false);
            cell.setImage(null);
            cell.redraw();
        }
        if (cellInfo.isQuestion()) {
            cellInfo.setQuestion(false);
            cell.setImage(null);
            cell.redraw();
        }
        if (cellInfo.isMine()) {
            cellInfo.setMine(false);
        }
        cellInfo.setWarning(0);
        cell.removeMouseListener((MouseListener)this.cellListener);
        cell.addMouseListener((MouseListener)this.cellListener);
    }

    private void show(Cell cell) {
        cell.removeMouseListener((MouseListener)this.cellListener);
        if (!cell.isButton()) {
            return;
        }
        CellInfo cellInfo = Controller.getCellInfo(cell);
        if (cellInfo.isMine() && !cellInfo.isFlag()) {
            cell.setType(2);
            cell.setImage(ResourceManager.INSTANCE.getImage("mine.gif"));
            cell.redraw();
        } else if (!cellInfo.isMine() && cellInfo.isFlag()) {
            cell.setType(2);
            cell.setImage(ResourceManager.INSTANCE.getImage("wrong.gif"));
            cell.redraw();
        }
    }

    private void showNewRecordDialog() {
        NewRecordDialog dialog = new NewRecordDialog(SWTUtils.getDisplay().getActiveShell(), this.view);
        dialog.open();
    }
}

