/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.workbench.Activator;
import com.centreon.studio.client.workbench.properties.Cell;
import com.centreon.studio.client.workbench.properties.Controller;
import com.centreon.studio.client.workbench.properties.Counter;
import com.centreon.studio.client.workbench.properties.ExpertAction;
import com.centreon.studio.client.workbench.properties.MainButtonListener;
import com.centreon.studio.client.workbench.properties.MinesweeperMessages;
import com.centreon.studio.client.workbench.properties.Preferences;
import com.centreon.studio.client.workbench.properties.ResourceManager;
import com.centreon.studio.client.workbench.properties.Timer;
import com.centreon.studio.client.workbench.properties.actions.BeginnerAction;
import com.centreon.studio.client.workbench.properties.actions.CustomAction;
import com.centreon.studio.client.workbench.properties.actions.IntermediateAction;
import com.centreon.studio.client.workbench.properties.actions.NewAction;
import com.centreon.studio.client.workbench.properties.actions.PauseAction;
import com.centreon.studio.client.workbench.properties.actions.RecordsAction;
import com.centreon.studio.client.workbench.properties.actions.SoundAction;
import java.applet.Applet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class MainView {
    private static final String SOUNDS2 = "sounds2/";
    private static final String ICONS2 = "icons2/";
    private Controller controller;
    private Button mainButton;
    private Counter counter;
    private Timer timer;
    private Composite composite;
    private Composite minesField;
    private ExpertAction expertAction;
    private IntermediateAction intermediateAction;
    private BeginnerAction beginnerAction;
    private CustomAction customAction;
    private PauseAction pauseAction;
    private final PreferenceStore store = new PreferenceStore(Configuration.APPLI_HOME + "\\easter.egg");

    public MainView() {
        try {
            this.store.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.store.setDefault("type", "expert");
        this.store.setDefault("nameExpert", "Anonymous");
        this.store.setDefault("timeExpert", 999);
        this.store.setDefault("nameIntermediate", "Anonymous");
        this.store.setDefault("timeIntermediate", 999);
        this.store.setDefault("nameBeginner", "Anonymous");
        this.store.setDefault("timeBeginner", 999);
        this.store.setDefault("soundMode", true);
        this.restoreState((IPreferenceStore)this.store);
    }

    public void createPartControl(Composite parent) {
        this.composite = parent;
        this.loadImages();
        this.loadSounds();
        this.open(parent);
        parent.addDisposeListener(e -> this.saveState(this.store));
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Controller getController() {
        return this.controller;
    }

    public Counter getCounter() {
        return this.counter;
    }

    public Button getMainButton() {
        return this.mainButton;
    }

    public Composite getMinesField() {
        return this.minesField;
    }

    public PauseAction getPauseAction() {
        return this.pauseAction;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void updateActionsUI(String mode) {
        URL aux = ResourceManager.INSTANCE.getURL("mark.gif");
        if (mode.equals("expert")) {
            this.expertAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
            this.intermediateAction.setImageDescriptor(null);
            this.beginnerAction.setImageDescriptor(null);
            this.customAction.setImageDescriptor(null);
        } else if (mode.equals("intermediate")) {
            this.expertAction.setImageDescriptor(null);
            this.intermediateAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
            this.beginnerAction.setImageDescriptor(null);
            this.customAction.setImageDescriptor(null);
        } else if (mode.equals("beginner")) {
            this.expertAction.setImageDescriptor(null);
            this.intermediateAction.setImageDescriptor(null);
            this.beginnerAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
            this.customAction.setImageDescriptor(null);
        } else {
            this.expertAction.setImageDescriptor(null);
            this.intermediateAction.setImageDescriptor(null);
            this.beginnerAction.setImageDescriptor(null);
            this.customAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
        }
    }

    private void createActions(Composite parent) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)new NewAction(MinesweeperMessages.getString("MainView.new"), this));
        menuMgr.add((IContributionItem)new Separator());
        this.beginnerAction = new BeginnerAction(MinesweeperMessages.getString("MainView.beginner"), this);
        menuMgr.add((IAction)this.beginnerAction);
        this.intermediateAction = new IntermediateAction(MinesweeperMessages.getString("MainView.intermediate"), this);
        menuMgr.add((IAction)this.intermediateAction);
        this.expertAction = new ExpertAction(MinesweeperMessages.getString("MainView.expert"), this);
        menuMgr.add((IAction)this.expertAction);
        this.customAction = new CustomAction(MinesweeperMessages.getString("MainView.custom"), this);
        menuMgr.add((IAction)this.customAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new RecordsAction(MinesweeperMessages.getString("MainView.scores"), this));
        menuMgr.add((IAction)new SoundAction(MinesweeperMessages.getString("MainView.sound"), ImageDescriptor.createFromURL((URL)ResourceManager.INSTANCE.getURL("sound.gif")), this));
        this.pauseAction = new PauseAction(MinesweeperMessages.getString("MainView.pause"), ImageDescriptor.createFromURL((URL)ResourceManager.INSTANCE.getURL("pause.gif")), this);
        menuMgr.add((IAction)this.pauseAction);
        URL aux = ResourceManager.INSTANCE.getURL("mark.gif");
        if (this.controller.getPreferences().getMode().equals("expert")) {
            this.expertAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
        } else if (this.controller.getPreferences().getMode().equals("intermediate")) {
            this.intermediateAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
        } else if (this.controller.getPreferences().getMode().equals("beginner")) {
            this.beginnerAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
        } else {
            this.customAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)aux));
        }
        parent.setMenu(menuMgr.createContextMenu((Control)parent));
    }

    private void createView(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        this.counter = new Counter(parent, 2048, 3, this.controller.getPreferences().getMinesCount());
        this.counter.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        gridData.verticalAlignment = 2;
        this.mainButton = new Button(parent, 8);
        this.mainButton.setImage(ResourceManager.INSTANCE.getImage("smile.gif"));
        this.mainButton.setLayoutData((Object)gridData);
        this.mainButton.setToolTipText(MinesweeperMessages.getString("MainView.reset"));
        this.mainButton.addMouseListener((MouseListener)new MainButtonListener(this));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.verticalAlignment = 2;
        this.timer = new Timer(parent, 2048, 3);
        this.timer.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.minesField = new Composite(parent, 0);
        this.minesField.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.controller.getPreferences().getColumns();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = true;
        this.minesField.setLayout((Layout)layout);
        this.controller.initMinesField(this.minesField);
        this.minesField.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Cell[] cells;
                Cell[] cellArray = cells = MainView.this.controller.getAllCells();
                int n = cells.length;
                int n2 = 0;
                while (n2 < n) {
                    Cell cell = cellArray[n2];
                    cell.setSize(((MainView)MainView.this).minesField.getSize().x / MainView.this.controller.getPreferences().getColumns(), ((MainView)MainView.this).minesField.getSize().y / MainView.this.controller.getPreferences().getRows());
                    ++n2;
                }
                MainView.this.minesField.layout();
            }
        });
    }

    private void loadImages() {
        this.loadImageWithTransparentColor("smile.gif");
        this.loadImageWithTransparentColor("mine.gif");
        this.loadImageWithTransparentColor("wrong.gif");
        this.loadImageWithTransparentColor("surprise.gif");
        ResourceManager.INSTANCE.putImage("explosion.gif", new Image((Device)Display.getCurrent(), this.getClass().getClassLoader().getResourceAsStream("icons2/explosion.gif")));
        this.loadImageWithTransparentColor("flag.gif");
        this.loadImageWithTransparentColor("question.gif");
        this.loadImageWithTransparentColor("sad.gif");
        this.loadImageWithTransparentColor("happy.gif");
        this.loadImageWithTransparentColor("1mines.gif");
        this.loadImageWithTransparentColor("2mines.gif");
        this.loadImageWithTransparentColor("3mines.gif");
        this.loadImageWithTransparentColor("4mines.gif");
        this.loadImageWithTransparentColor("5mines.gif");
        this.loadImageWithTransparentColor("6mines.gif");
        this.loadImageWithTransparentColor("7mines.gif");
        this.loadImageWithTransparentColor("8mines.gif");
        try {
            URL url = new URL(Activator.getContext().getBundle().getEntry("/"), ICONS2);
            ResourceManager.INSTANCE.putURL("mark.gif", new URL(url, "mark.gif"));
            ResourceManager.INSTANCE.putURL("sound.gif", new URL(url, "sound.gif"));
            ResourceManager.INSTANCE.putURL("pause.gif", new URL(url, "pause.gif"));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    private void loadImageWithTransparentColor(String s) {
        ImageData imageData = new ImageData(this.getClass().getClassLoader().getResourceAsStream(ICONS2 + s));
        ImageData aux = null;
        if (imageData.transparentPixel > 0) {
            aux = imageData.getTransparencyMask();
        }
        ResourceManager.INSTANCE.putImage(s, new Image((Device)Display.getCurrent(), imageData, aux));
    }

    private void loadSounds() {
        ResourceManager.INSTANCE.putSound("explode.wav", Applet.newAudioClip(this.getClass().getClassLoader().getResource("sounds2/explode.wav")));
        ResourceManager.INSTANCE.putSound("start.wav", Applet.newAudioClip(this.getClass().getClassLoader().getResource("sounds2/start.wav")));
        ResourceManager.INSTANCE.putSound("bip.wav", Applet.newAudioClip(this.getClass().getClassLoader().getResource("sounds2/bip.wav")));
        ResourceManager.INSTANCE.putSound("finish.wav", Applet.newAudioClip(this.getClass().getClassLoader().getResource("sounds2/finish.wav")));
    }

    private void open(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        this.createView(parent);
        this.createActions(parent);
    }

    private void restoreState(IPreferenceStore store) {
        Preferences preferences = new Preferences();
        String mode = store.getString("type");
        preferences.setMode(mode);
        if (mode.equals("expert")) {
            preferences.setRows(16);
            preferences.setColumns(30);
            preferences.setMinesCount(99);
        } else if (mode.equals("intermediate")) {
            preferences.setRows(16);
            preferences.setColumns(16);
            preferences.setMinesCount(40);
        } else if (mode.equals("beginner")) {
            preferences.setRows(9);
            preferences.setColumns(9);
            preferences.setMinesCount(10);
        } else {
            preferences.setRows(store.getInt("rowsCustom"));
            preferences.setColumns(store.getInt("columnsCustom"));
            preferences.setMinesCount(store.getInt("minesCustom"));
        }
        HashMap<String, Object> records = new HashMap<String, Object>();
        records.put("nameExpert", store.getString("nameExpert"));
        records.put("timeExpert", new Integer(store.getInt("timeExpert")));
        records.put("nameIntermediate", store.getString("nameIntermediate"));
        records.put("timeIntermediate", new Integer(store.getInt("timeIntermediate")));
        records.put("nameBeginner", store.getString("nameBeginner"));
        records.put("timeBeginner", new Integer(store.getInt("timeBeginner")));
        preferences.setSoundEnabled(store.getBoolean("soundMode"));
        this.controller = new Controller(this, preferences, records);
    }

    private void saveState(PreferenceStore store) {
        store.setValue("type", this.controller.getPreferences().getMode());
        store.setValue("minesCustom", this.controller.getPreferences().getMinesCount());
        store.setValue("rowsCustom", this.controller.getPreferences().getRows());
        store.setValue("columnsCustom", this.controller.getPreferences().getColumns());
        store.setValue("soundMode", this.controller.getPreferences().isSoundEnabled());
        Map<String, Object> records = this.controller.getRecords();
        for (Map.Entry<String, Object> entry : records.entrySet()) {
            store.setValue(entry.getKey(), entry.getValue().toString());
        }
        try {
            store.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

