/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.workbench.properties;

import java.applet.AudioClip;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public enum ResourceManager {
    INSTANCE;

    private final Map<Integer, Color> colors = new HashMap<Integer, Color>();
    private final Map<String, Image> images = new HashMap<String, Image>();
    private final Map<String, Font> fonts = new HashMap<String, Font>();
    private final Map<String, AudioClip> sounds = new HashMap<String, AudioClip>();
    private final Map<String, URL> urls = new HashMap<String, URL>();

    public void dispose() {
        Iterator<Color> i = this.colors.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        i = this.fonts.values().iterator();
        while (i.hasNext()) {
            ((Font)i.next()).dispose();
        }
        i = this.images.values().iterator();
        while (i.hasNext()) {
            ((Image)i.next()).dispose();
        }
    }

    public Color getColor(int param1) {
        return this.colors.get(new Integer(param1));
    }

    public Font getFont(String param1) {
        return this.fonts.get(param1);
    }

    public Image getImage(String param1) {
        return this.images.get(param1);
    }

    public AudioClip getSound(String param1) {
        return this.sounds.get(param1);
    }

    public URL getURL(String param1) {
        return this.urls.get(param1);
    }

    public void putColor(int param1, Color param2) {
        this.colors.put(new Integer(param1), param2);
    }

    public void putFont(String param1, Font param2) {
        this.fonts.put(param1, param2);
    }

    public void putImage(String param1, Image param2) {
        this.images.put(param1, param2);
    }

    public void putSound(String param1, AudioClip param2) {
        this.sounds.put(param1, param2);
    }

    public void putURL(String param1, URL param2) {
        this.urls.put(param1, param2);
    }
}

