/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.process;

import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.dialogs.CustomWizard;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardDialog;
import com.centreon.studio.client.model.ui.dialogs.CustomWizardPage;
import com.centreon.studio.client.model.ui.dialogs.IWizardFactory;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.wizards.ElementPropertiesWizardPage;
import com.centreon.studio.map.client.elements.model.ui.wizards.ResourceWizardPage;
import com.centreon.studio.map.client.elements.widgets.messages.WidgetMessages;
import com.centreon.studio.map.client.elements.widgets.process.ProcessWidgetNodeFactory;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import com.centreon.studio.map.client.status.model.StatusTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public enum ProcessWidgetWizardFactory implements IWizardFactory
{
    INSTANCE;

    private static final Collection<TypeDescriptor> SERVICE_TYPE;

    static {
        SERVICE_TYPE = Arrays.asList(ResourceTypes.RESOURCE_SERVICE);
    }

    public CustomWizardDialog createDialog(INodeRelation input, IEclipseContext context) {
        if (input == null) {
            return null;
        }
        ResourceRepositoryDecorator resourceRepositoryDecorator = (ResourceRepositoryDecorator)ContextInjectionFactory.make(ResourceRepositoryDecorator.class, (IEclipseContext)context);
        resourceRepositoryDecorator.setSelection((Object)this, null);
        INode decoratedHostRepository = INodeUtils.findNode((INode)resourceRepositoryDecorator, (TypeDescriptor)ResourceTypes.RESOURCE_HOST, null, (PropertyValue[])new PropertyValue[0]);
        RepositoryDecorator elementRepositoryDecorator = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
        List<TypeDescriptor> exclude = Arrays.asList(ResourceTypes.RESOURCE_SERVICE, StatusTypes.METRIC);
        CustomWizard wizard = new CustomWizard("Process Widget");
        wizard.registerPage((CustomWizardPage)new ElementPropertiesWizardPage());
        wizard.registerPage((CustomWizardPage)new ResourceWizardPage(decoratedHostRepository, elementRepositoryDecorator, SERVICE_TYPE, WidgetMessages.resourcePageLabel, exclude, new TypeDescriptor[]{ResourceTypes.RESOURCE_RELATION, ResourceTypes.RESOURCE_RELATION_LEAF}));
        CustomWizardDialog dialog = new CustomWizardDialog(wizard);
        dialog.setInput(Arrays.asList(input));
        return dialog;
    }

    public Set<TypeDescriptor> getSupportedTypes() {
        return new HashSet<TypeDescriptor>(new ProcessWidgetNodeFactory().getSupportedTypes());
    }
}

