/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.sound;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.events.sound.SoundEvent;
import com.centreon.studio.client.events.sound.SoundEventHandler;
import com.centreon.studio.client.sound.SoundPlayer;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class SoundAddon
extends SoundEventHandler {
    private SoundPlayer soundPlayer;
    private final BrokerEventManager eventManager;

    @Inject
    public SoundAddon(BrokerEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void handleEvent(SoundEvent event) {
        try {
            File file = new File(event.getPath());
            if (this.soundPlayer == null) {
                this.soundPlayer = new SoundPlayer(file.toURI().toURL());
            }
            if (!this.soundPlayer.isCurrentlyPlaying()) {
                this.soundPlayer.setURL(file.toURI().toURL());
                this.soundPlayer.run();
            }
        }
        catch (IOException e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    @PostConstruct
    public void postConstruct() {
        this.eventManager.subscribe("studio/sounds", true, (StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Sound addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    protected void preDestroy() {
        this.eventManager.unsubscribe((StudioEventHandler)this);
        this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"Sound addon destroyed", (Object[])new Object[0]));
    }
}

