/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.popup;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.events.popup.PopUpEvent;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class NotifierDialog {
    private static final int FADE_TIMER = 50;
    private static final int FADE_IN_STEP = 30;
    private static final int FADE_OUT_STEP = 8;
    private static final int SECURE_FADE_OUT_TIME_OUT = 500;
    private static final int SECURE_FADE_IN_TIME_OUT = 250;
    private static final int FINAL_ALPHA = 225;
    private static Color TITLE_FG_COLOR = StudioRegistries.colorRegistry().getSWTColorFrom(new StudioColor(40, 73, 97));
    private static Color BG_FB_GRADIENT = StudioRegistries.colorRegistry().getSWTColorFrom(new StudioColor(226, 239, 249));
    private static Color BG_BG_GRADIENT = StudioRegistries.colorRegistry().getSWTColorFrom(new StudioColor(177, 211, 243));
    private static Color BORDER_COLOR = TITLE_FG_COLOR;
    private static Color FG_COLOR = TITLE_FG_COLOR;
    private static List<Shell> ACTIVE_SHELLS = new ArrayList<Shell>(20);
    private static Image OLD_IMAGE;

    public static void notify(final PopUpEvent event, Rectangle rectangle) {
        final Shell shell = SWTUtils.createShellTool((int)2, (boolean)false, (boolean)false, (boolean)true, (int)5, (boolean)false);
        shell.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        shell.setBackgroundMode(1);
        shell.setForeground(event.getColor());
        shell.setAlpha(0);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ACTIVE_SHELLS.remove(shell);
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    NotifierDialog.close(shell);
                }
            }
        });
        shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                try {
                    Rectangle rect = shell.getClientArea();
                    Image newImage = new Image((Device)Display.getDefault(), Math.max(1, rect.width), rect.height);
                    GC gc = new GC((Drawable)newImage);
                    gc.setForeground(BG_FB_GRADIENT);
                    gc.setBackground(BG_BG_GRADIENT);
                    gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
                    gc.setLineWidth(2);
                    gc.setForeground(BORDER_COLOR);
                    gc.drawRectangle(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                    gc.dispose();
                    shell.setBackgroundImage(newImage);
                    if (OLD_IMAGE != null) {
                        OLD_IMAGE.dispose();
                    }
                    OLD_IMAGE = newImage;
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
        Composite textComposite = SWTUtils.createComposite((Composite)shell, (int)2, (boolean)false, (int)5, (int)5, (GridData)SWTUtils.createGridDataFill());
        if (!StringUtils.isNullEmptyOrBlank((String)event.getImagePath())) {
            Image img = SWTUtils.getImageFromUrl((String)event.getImagePath());
            CLabel imgLabel = new CLabel(textComposite, 0);
            imgLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            imgLabel.setImage(img);
        }
        if (!StringUtils.isNullEmptyOrBlank((String)event.getTitle())) {
            if (event.getColor() != null) {
                CLabel statusLabel = new CLabel(textComposite, 2048);
                statusLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
                statusLabel.setText("     ");
                statusLabel.setBackground(event.getColor());
            }
            CLabel titleLabel = new CLabel(textComposite, 0);
            titleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            titleLabel.setFont(StudioRegistries.fontRegistry().getSWTFontFrom(StudioFont.DEFAULT));
            titleLabel.setForeground(TITLE_FG_COLOR);
            titleLabel.setText(event.getTitle());
        }
        if (!StringUtils.isNullEmptyOrBlank((String)event.getMessage())) {
            GridData gd = new GridData(4, 0x1000000, true, true);
            gd.horizontalSpan = 2;
            Label text = new Label(textComposite, 64);
            text.setFont(StudioRegistries.fontRegistry().getSWTFontFrom(StudioFont.DEFAULT));
            text.setForeground(FG_COLOR);
            text.setText(event.getMessage());
            text.setLayoutData((Object)gd);
        }
        GridData buttonCompositeData = new GridData(0x1000008, 0x1000000, false, true);
        buttonCompositeData.minimumWidth = 100;
        Composite buttonComposite = SWTUtils.createComposite((Composite)shell, (int)1, (boolean)false, (int)5, (int)5, (GridData)buttonCompositeData);
        SWTUtils.createButtonPush((Composite)buttonComposite, (GridData)new GridData(0x1000008, 0x1000008, true, false), (String)CommonsMessages.keywordClose, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NotifierDialog.close(shell);
            }
        });
        if (event.getAction() != null) {
            SWTUtils.createButtonPush((Composite)buttonComposite, (GridData)new GridData(0x1000008, 0x1000008, true, false), (String)event.getAction().getLabel(), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SWTUtils.getDisplay().asyncExec((Runnable)event.getAction());
                    NotifierDialog.close(shell);
                }
            });
        }
        if (!ACTIVE_SHELLS.isEmpty()) {
            ArrayList<Shell> modifiable = new ArrayList<Shell>(ACTIVE_SHELLS);
            Collections.reverse(modifiable);
            for (Shell s : modifiable) {
                Point curLoc = s.getLocation();
                int newY = curLoc.y - rectangle.height;
                s.setLocation(curLoc.x, newY);
                if ((curLoc.y <= 0 || newY >= 0) && (curLoc.y >= 0 || newY <= 0)) continue;
                NotifierDialog.close(shell);
            }
        }
        shell.setVisible(true);
        ACTIVE_SHELLS.add(shell);
        NotifierDialog.fadeIn(shell, event.getDuration().intValue());
    }

    private static void close(Shell shell) {
        if (!shell.isDisposed()) {
            NotifierDialog.removeShell(shell);
            shell.close();
        }
    }

    private static void fadeIn(final Shell shell, final int displayTime) {
        Display.getDefault().timerExec(50, new Runnable(){
            int securedTimeout = 250;

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    --this.securedTimeout;
                    if ((cur += 30) > 225 || this.securedTimeout <= 0) {
                        shell.setAlpha(225);
                        NotifierDialog.startTimer(shell, displayTime);
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
    }

    private static void fadeOut(final Shell shell) {
        Display.getDefault().timerExec(50, new Runnable(){
            int securedTimeout = 500;

            @Override
            public void run() {
                try {
                    if (shell == null || shell.isDisposed()) {
                        return;
                    }
                    int cur = shell.getAlpha();
                    --this.securedTimeout;
                    if ((cur -= 8) <= 0 || this.securedTimeout <= 0) {
                        shell.setAlpha(0);
                        if (OLD_IMAGE != null) {
                            OLD_IMAGE.dispose();
                        }
                        shell.dispose();
                        ACTIVE_SHELLS.remove(shell);
                        return;
                    }
                    shell.setAlpha(cur);
                    Display.getDefault().timerExec(50, (Runnable)this);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
    }

    private static void removeShell(Shell shell) {
        if (ACTIVE_SHELLS.isEmpty()) {
            return;
        }
        int index = -1;
        int i = ACTIVE_SHELLS.size() - 1;
        while (i >= 0) {
            Shell activeShell = ACTIVE_SHELLS.get(i);
            if (!activeShell.isDisposed() && activeShell.getLocation().y == shell.getLocation().y) {
                index = i;
                break;
            }
            --i;
        }
        if (index == -1) {
            return;
        }
        final int actualIndex = index;
        final int moveSize = shell.getBounds().height / 50;
        int i2 = 0;
        while (i2 < 50) {
            Display.getCurrent().timerExec(5 * i2, new Runnable(){

                @Override
                public void run() {
                    int j = actualIndex - 1;
                    while (j >= 0) {
                        Shell s = (Shell)ACTIVE_SHELLS.get(j);
                        if (!s.isDisposed()) {
                            Point curLoc = s.getLocation();
                            s.setLocation(curLoc.x, curLoc.y + moveSize);
                        }
                        --j;
                    }
                }
            });
            ++i2;
        }
    }

    private static void startTimer(final Shell shell, int displayTime) {
        if (displayTime < 0) {
            return;
        }
        Display.getDefault().timerExec(displayTime * 1000, new Runnable(){

            @Override
            public void run() {
                try {
                    NotifierDialog.fadeOut(shell);
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
            }
        });
    }

    private NotifierDialog() {
    }
}

