/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.cxf;

import com.centreon.studio.client.cxf.Activator;
import com.centreon.studio.client.cxf.WebServiceManager;
import com.centreon.studio.client.events.update.StudioVersion;
import com.centreon.studio.client.utils.StringUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public abstract class AWebService<T>
implements X509TrustManager {
    private static final String URI_ORG_APACHE_CXF = "uri:org.apache.cxf";
    private static final String SESSION = "session";
    private static final String CLIENT_VERSION = "X-Client-Version";
    private final JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
    private final Class<T> serviceClass;
    private final String wsdl;
    private final boolean useGzip;
    private boolean isInit;
    protected T service;

    private static void addHeader(Client client, String headerName, String headerValue) {
        try {
            QName qName = new QName(URI_ORG_APACHE_CXF, headerName);
            JAXBDataBinding db = new JAXBDataBinding(new Class[]{String.class});
            Header header = new Header(qName, (Object)headerValue, (DataBinding)db);
            ArrayList<Header> headers = (ArrayList<Header>)client.getRequestContext().get(Header.HEADER_LIST);
            if (headers == null) {
                headers = new ArrayList<Header>(1);
                client.getRequestContext().put(Header.HEADER_LIST, headers);
            }
            headers.add(header);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    protected AWebService(String wsdl, Class<T> serviceClass, boolean useGzip) {
        this.serviceClass = serviceClass;
        this.wsdl = wsdl;
        this.useGzip = useGzip;
        WebServiceManager.INSTANCE.register(this);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    public void init(String url, String token) {
        this.isInit = false;
        if (!StringUtils.isNullEmptyOrBlank((String)url)) {
            this.factory.setAddress(String.valueOf(url) + this.wsdl);
            this.service = this.factory.create(this.serviceClass);
            Client client = ClientProxy.getClient(this.service);
            if (this.useGzip) {
                client.getInInterceptors().add(new GZIPInInterceptor());
                client.getOutInterceptors().add(new GZIPOutInterceptor());
            }
            if (!StringUtils.isNullEmptyOrBlank((String)token)) {
                AWebService.addHeader(client, SESSION, token);
            }
            StudioVersion clientVersion = new StudioVersion(Activator.getContext().getBundle().getVersion());
            AWebService.addHeader(client, CLIENT_VERSION, clientVersion.getFullVersion());
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            TLSClientParameters tlsParams = new TLSClientParameters();
            tlsParams.setTrustManagers(new TrustManager[]{this});
            tlsParams.setDisableCNCheck(true);
            conduit.setTlsClientParameters(tlsParams);
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setAutoRedirect(true);
            httpClientPolicy.setAllowChunking(false);
            String stringTimeout = System.getProperty("sun.net.client.defaultReadTimeout");
            if (stringTimeout != null) {
                Integer timeout = Integer.valueOf(stringTimeout);
                httpClientPolicy.setConnectionTimeout((long)timeout.intValue());
                httpClientPolicy.setReceiveTimeout((long)timeout.intValue());
            }
            conduit.setClient(httpClientPolicy);
            String proxyUsername = System.getProperty("http.proxyUser");
            String proxyPassword = System.getProperty("http.proxyPassword");
            if (!StringUtils.isNullEmptyOrBlank((String)proxyUsername)) {
                conduit.getProxyAuthorization().setUserName(proxyUsername);
                conduit.getProxyAuthorization().setPassword(proxyPassword);
            }
            this.isInit = this.isWebServiceInitialized();
        }
    }

    protected final boolean isInit() {
        return this.isInit;
    }

    protected boolean isWebServiceInitialized() {
        return true;
    }
}

