/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui;

import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.ui.actions.common.IUndoHandler;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.messages.ModelUiMessages;
import com.centreon.studio.client.preference.model.PreferenceSaveRepositoryStrategy;
import com.centreon.studio.client.preference.ui.PreferenceParser;
import com.centreon.studio.client.preference.ui.StudioPreferenceDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;

public final class OpenPreferencesAction
extends StudioAction {
    private final PreferenceParser parser;
    private final IPreferenceStore store;
    private final PreferenceSaveRepositoryStrategy strategy;

    public OpenPreferencesAction(PreferenceSaveRepositoryStrategy strategy, IPreferenceStore store, PreferenceParser parser) {
        super(ModelUiMessages.keywordPreferences);
        this.strategy = strategy;
        this.parser = parser;
        this.store = store;
    }

    public final int getAccelerator() {
        return SWT.MOD1 | 0x50;
    }

    protected IUndoHandler internalRun() {
        PreferenceManager manager = this.parser.parsePreferences(this.store);
        StudioPreferenceDialog dialog = new StudioPreferenceDialog(SWTUtils.getDisplay().getActiveShell(), manager, this.strategy);
        dialog.setPreferenceStore(this.store);
        dialog.setHelpAvailable(false);
        dialog.create();
        dialog.getTreeViewer().setComparator(new ViewerComparator());
        dialog.open();
        return null;
    }
}

