/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui.fields;

import com.centreon.studio.client.commons.swt.CustomScale;
import com.centreon.studio.client.commons.swt.SWTUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;

public class CustomScaleFieldEditor
extends FieldEditor {
    protected CustomScale customScale;
    private int oldValue;
    private int maxValue;
    private int minValue;
    private int incrementValue;
    private int pageIncrementValue;

    public CustomScaleFieldEditor(String name, String labelText, Composite parent, int min, int max, int increment, int pageIncrement) {
        super(name, labelText, parent);
        this.maxValue = max;
        this.minValue = min;
        this.incrementValue = increment;
        this.pageIncrementValue = pageIncrement;
        this.updateScale();
    }

    public int getIncrement() {
        return this.incrementValue;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public int getPageIncrement() {
        return this.pageIncrementValue;
    }

    public Scale getScaleControl() {
        return this.customScale.getScale();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.customScale.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.customScale != null && !this.customScale.getScale().isDisposed()) {
            this.customScale.getScale().setFocus();
        }
    }

    public void setIncrement(int increment) {
        this.incrementValue = increment;
        this.updateScale();
    }

    public void setMaximum(int max) {
        this.maxValue = max;
        this.updateScale();
    }

    public void setMinimum(int min) {
        this.minValue = min;
        this.updateScale();
    }

    public void setPageIncrement(int pageIncrement) {
        this.pageIncrementValue = pageIncrement;
        this.updateScale();
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.customScale.getScale().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent).setLayoutData((Object)new GridData());
        this.customScale = SWTUtils.createScale((Composite)parent, null, (int)0, (int)this.maxValue);
        this.customScale.getScale().setFont(parent.getFont());
        this.customScale.getScale().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CustomScaleFieldEditor.this.valueChanged();
            }
        });
        this.customScale.getScale().addDisposeListener(event -> {
            CustomScale customScale = this.customScale = null;
        });
        this.updateScale();
    }

    protected void doLoad() {
        if (this.customScale != null) {
            int value = this.getPreferenceStore().getInt(this.getPreferenceName());
            this.customScale.setSelection(value);
            this.oldValue = value;
        }
    }

    protected void doLoadDefault() {
        if (this.customScale != null) {
            int value = this.getPreferenceStore().getDefaultInt(this.getPreferenceName());
            this.customScale.setSelection(value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.customScale.getSelection());
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        int newValue = this.customScale.getSelection();
        if (newValue != this.oldValue) {
            this.fireStateChanged("field_editor_is_valid", false, true);
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    private void updateScale() {
        if (this.customScale != null && !this.customScale.getScale().isDisposed()) {
            this.customScale.setMinimum(this.getMinimum());
            this.customScale.setMaximum(this.getMaximum());
            this.customScale.setIncrement(this.getIncrement());
            this.customScale.setPageIncrement(this.getPageIncrement());
        }
    }
}

