/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui.fields;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.preference.ui.StudioPreferenceStore;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class PropertyColorFieldEditor
extends ColorFieldEditor {
    private final IForm form;
    private final Composite parent;

    public PropertyColorFieldEditor(String preferenceName, String label, Composite parent, IForm form) {
        super(preferenceName, label, parent);
        this.parent = parent;
        this.form = form;
    }

    public StudioPreferenceStore getPreferenceStore() {
        return (StudioPreferenceStore)super.getPreferenceStore();
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = new GridData();
        if (this.getLabelControl(this.parent).getLayoutData() != null) {
            gd = (GridData)this.getLabelControl(this.parent).getLayoutData();
        }
        gd.horizontalSpan = numColumns - 1;
        this.getLabelControl(this.parent).setLayoutData((Object)gd);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)gd);
        Button colorButton = this.getChangeControl(parent);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000008;
        gd2.verticalAlignment = 0x1000000;
        colorButton.setLayoutData((Object)gd2);
    }

    protected void doLoad() {
        if (this.getColorSelector() == null) {
            return;
        }
        StudioColor studioColor = this.getPreferenceStore().getValue(StudioColor.class, this.getPreferenceName(), null);
        Color swtColor = StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
        if (swtColor != null && !this.getColorSelector().getButton().isDisposed()) {
            this.getColorSelector().setColorValue(swtColor.getRGB());
        }
    }

    protected void doLoadDefault() {
        if (this.getColorSelector() == null) {
            return;
        }
        StudioColor studioColor = this.getPreferenceStore().getDefaultValue(StudioColor.class, this.getPreferenceName(), null);
        Color swtColor = StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
        if (swtColor != null && !this.getColorSelector().getButton().isDisposed()) {
            this.getColorSelector().setColorValue(swtColor.getRGB());
        }
    }

    protected void doStore() {
        RGB rgb = this.getColorSelector().getColorValue();
        StudioColor studioColor = StudioRegistries.colorRegistry().getStudioColorFrom(rgb);
        this.getPreferenceStore().setValue(StudioColor.class, this.getPreferenceName(), studioColor);
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        super.fireValueChanged(property, oldValue, newValue);
        if (this.form != null) {
            this.form.setChange((Control)this.getLabelControl(), true);
            this.form.setValidation((Control)this.getLabelControl(), true);
        }
    }
}

