/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.preference.ui.fields;

import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.swt.SWTUtils;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.preference.ui.StudioPreferenceStore;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

public class PropertyPosFieldEditor
extends FieldEditor {
    private final Spinner heightSpinner;
    private final Spinner widthSpinner;
    private final Label secondLabel;
    private final Label firstLabel;
    private final IForm form;
    private Integer minValue = 0;
    private Integer maxValue = Integer.MAX_VALUE;
    private Integer increment = 1;
    private Integer pageIncrement = 10;
    private Integer numberDigits = 0;
    private Pos pos;

    public PropertyPosFieldEditor(String preferenceName, String label, Composite parent, IForm form) {
        super(preferenceName, label, parent);
        SWTUtils.createSpanner((Composite)parent, (int)1, (int)0);
        this.form = form;
        this.firstLabel = SWTUtils.createLabel((Composite)parent, (String)"Width");
        this.widthSpinner = SWTUtils.createSpiner((Composite)parent, null, (int)0, (int)this.minValue, (int)this.maxValue, (int)this.increment, (int)this.pageIncrement);
        this.secondLabel = SWTUtils.createLabel((Composite)parent, (String)"Height");
        this.heightSpinner = SWTUtils.createSpiner((Composite)parent, null, (int)0, (int)this.minValue, (int)this.maxValue, (int)this.increment, (int)this.pageIncrement);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public StudioPreferenceStore getPreferenceStore() {
        return (StudioPreferenceStore)super.getPreferenceStore();
    }

    public void setBounds(int minValue, int maxValue, int increment, int pageIncrement, int digits) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        this.numberDigits = digits;
    }

    public void setLabels(String first, String second) {
        this.firstLabel.setText(first);
        this.secondLabel.setText(second);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalSpan = numColumns - 1;
        gd.horizontalAlignment = 1;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.widthSpinner == null || this.heightSpinner == null) {
            return;
        }
        this.doLoadDefault();
    }

    protected void doLoadDefault() {
        Pos p = this.getPreferenceStore().getValue(Pos.class, this.getPreferenceName(), null);
        if (p != null && !this.widthSpinner.isDisposed() && !this.heightSpinner.isDisposed()) {
            this.pos = p;
            this.widthSpinner.setValues(this.pos.x.intValue(), this.minValue.intValue(), this.maxValue.intValue(), this.numberDigits.intValue(), this.increment.intValue(), this.pageIncrement.intValue());
            this.heightSpinner.setValues(this.pos.y.intValue(), this.minValue.intValue(), this.maxValue.intValue(), this.numberDigits.intValue(), this.increment.intValue(), this.pageIncrement.intValue());
        }
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(Pos.class, this.getPreferenceName(), Pos.create((double)Integer.parseInt(this.widthSpinner.getText()), (double)Integer.parseInt(this.heightSpinner.getText())));
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        super.fireValueChanged(property, oldValue, newValue);
        if (this.form != null) {
            this.form.setChange((Control)this.getLabelControl(), true);
            this.form.setValidation((Control)this.getLabelControl(), true);
        }
    }
}

