/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.NodeMapper;
import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.IObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.model.repository.IRepository;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.map.element.ElementDto;
import com.centreon.studio.map.element.ElementRelationDto;
import com.centreon.studio.map.elementservice.ElementPortType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public abstract class ANodeWebService
extends AWebService<ElementPortType>
implements IWebService {
    private final BrokerEventManager eventManager;
    private final IRepository repository;

    @Inject
    public ANodeWebService(IRepository repository, BrokerEventManager eventManager) {
        super("/centreon-studio/services/element?wsdl", ElementPortType.class, !Configuration.SKIP_GZIP);
        this.eventManager = eventManager;
        this.repository = repository;
    }

    @Override
    public Map<INode, Collection<INodeRelation>> create(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        if (!this.isInit()) {
            return Collections.emptyMap();
        }
        List dtos = new ArrayList<ElementDto>();
        List relationDtos = new ArrayList<ElementRelationDto>();
        for (Map.Entry<INode, Collection<INodeRelation>> entry : nodeToRelations.entrySet()) {
            if (entry.getKey().equals((Object)this.repository)) {
                for (INodeRelation relation : entry.getValue()) {
                    dtos.add(NodeMapper.nodeToDto(relation.getTarget(), true));
                }
                continue;
            }
            relationDtos.addAll(NodeMapper.relationsToDtos(entry.getValue(), true));
        }
        HashMap<Long, INode> cache = new HashMap<Long, INode>(nodeToRelations.keySet().size());
        for (INode parent : nodeToRelations.keySet()) {
            cache.put(parent.getId(), parent);
        }
        try {
            HashMap<INode, Collection<INodeRelation>> result = new HashMap<INode, Collection<INodeRelation>>(nodeToRelations.size());
            Collection<INodeRelation> children = new ArrayList<INodeRelation>(dtos.size());
            if (!dtos.isEmpty()) {
                dtos = ((ElementPortType)this.service).addElements(null, dtos);
                for (ElementDto dto : dtos) {
                    INode node = NodeMapper.dtoToNode(dto, this.repository, new PropertyValue[0]);
                    children.add(NodeRelationFactories.INSTANCE.create(this.getRelationType(), SequenceUtils.next(), (INode)this.repository, node));
                }
                result.put((INode)this.repository, children);
            }
            if (!relationDtos.isEmpty()) {
                relationDtos = ((ElementPortType)this.service).addElementRelations(null, relationDtos);
                for (ElementDto dto : relationDtos) {
                    INode parent = (INode)cache.get(dto.getParentId());
                    if (parent != null) {
                        INodeRelation relation = NodeMapper.dtoToRelation((ElementRelationDto)dto, parent, new PropertyValue[0]);
                        children = (Collection)result.get(parent);
                        if (children == null) {
                            children = new ArrayList();
                            result.put(parent, children);
                        }
                        children.add(relation);
                        continue;
                    }
                    this.eventManager.async((StudioEvent)LogEvent.error(this.getClass(), (String)"Couldn't find parent {}", (Object[])new Object[]{dto.getParentId()}));
                }
            }
            for (Map.Entry entry : result.entrySet()) {
                ((INode)entry.getKey()).addRelations((Collection)entry.getValue());
            }
            return result;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            return Collections.emptyMap();
        }
    }

    @Override
    public final List<INodeRelation> getElementsByIds(List<Long> ids) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        StepTimeTracker counter = new StepTimeTracker("get() " + ids.size() + " " + ids);
        try {
            ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>(ids.size());
            List dtos = ((ElementPortType)this.service).getElements(null, ids, -1);
            for (ElementDto dto : dtos) {
                INode node = NodeMapper.dtoToNode(dto, this.repository, new PropertyValue[0]);
                relations.add(NodeRelationFactories.INSTANCE.create(this.getRelationType(), node.getId(), (INode)this.repository, node));
            }
            ArrayList<INodeRelation> arrayList = relations;
            return arrayList;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            List<INodeRelation> list = Collections.emptyList();
            return list;
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
    }

    @Override
    public final List<INodeRelation> getElementsByTypes(List<TypeDescriptor> types) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        StepTimeTracker counter = new StepTimeTracker("getAll() " + types);
        try {
            ArrayList<Integer> dtoTypes = new ArrayList<Integer>(types.size());
            for (TypeDescriptor type : types) {
                dtoTypes.add(type.getId());
            }
            List dtos = ((ElementPortType)this.service).getElementsByType(null, dtoTypes, -1);
            ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>(dtos.size());
            for (ElementDto dto : dtos) {
                INode node = NodeMapper.dtoToNode(dto, this.repository, new PropertyValue[0]);
                relations.add(NodeRelationFactories.INSTANCE.create(this.getRelationType(), node.getId(), (INode)this.repository, node));
            }
            ArrayList<INodeRelation> arrayList = relations;
            return arrayList;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            List<INodeRelation> list = Collections.emptyList();
            return list;
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
    }

    @Override
    public final List<INodeRelation> getRelationsByIds(List<Long> ids) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        StepTimeTracker counter = new StepTimeTracker("getRelationsByIds() " + ids.size() + " " + ids);
        try {
            ArrayList<INodeRelation> relations = new ArrayList<INodeRelation>(ids.size());
            List dtos = ((ElementPortType)this.service).getElementsRelations(null, ids, -1);
            for (ElementRelationDto dto : dtos) {
                INode parent = INodeUtils.findNode((INode)this.repository, null, (Long)dto.getParentId(), (PropertyValue[])new PropertyValue[0]);
                if (parent == null) continue;
                INodeRelation template = NodeMapper.dtoToRelation(dto, parent, new PropertyValue[0]);
                relations.add(template);
            }
            ArrayList<INodeRelation> arrayList = relations;
            return arrayList;
        }
        catch (Exception e) {
            this.eventManager.sync((StudioEvent)new ExceptionEvent((Throwable)e));
            List<INodeRelation> list = Collections.emptyList();
            return list;
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
    }

    @Override
    public final boolean remove(Map<INode, Collection<INodeRelation>> nodeToRelationsRemove) {
        if (!this.isInit()) {
            return false;
        }
        ArrayList<Long> elementsIds = new ArrayList<Long>();
        ArrayList<Long> relationsIds = new ArrayList<Long>();
        for (Collection<INodeRelation> collection : nodeToRelationsRemove.values()) {
            for (INodeRelation relation : collection) {
                if (relation.getSource() instanceof IRepository) {
                    elementsIds.add(relation.getTarget().getId());
                    continue;
                }
                relationsIds.add(relation.getId());
            }
        }
        if (!elementsIds.isEmpty()) {
            try {
                ((ElementPortType)this.service).removeElements(null, elementsIds);
                for (Map.Entry entry : nodeToRelationsRemove.entrySet()) {
                    if (!(entry.getKey() instanceof IRepository)) continue;
                    ((INode)entry.getKey()).removeRelations((Collection)entry.getValue());
                }
            }
            catch (Exception exception) {
                this.eventManager.sync((StudioEvent)new ExceptionEvent((Throwable)exception));
                return false;
            }
        }
        if (!relationsIds.isEmpty()) {
            try {
                ((ElementPortType)this.service).removeElementRelations(null, relationsIds);
                for (Map.Entry entry : nodeToRelationsRemove.entrySet()) {
                    if (entry.getKey() instanceof IRepository) continue;
                    ((INode)entry.getKey()).removeRelations((Collection)entry.getValue());
                }
            }
            catch (Exception exception) {
                this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)exception));
                return false;
            }
        }
        return true;
    }

    @Override
    public final void update(Collection<INode> nodes) {
        if (!this.isInit()) {
            return;
        }
        List dtos = new ArrayList<ElementDto>(nodes.size());
        HashMap<Long, INode> cache = new HashMap<Long, INode>(nodes.size());
        for (INode node : nodes) {
            dtos.add(NodeMapper.nodeToDto(node, false));
            cache.put(node.getId(), node);
        }
        try {
            dtos = ((ElementPortType)this.service).updateElements(null, dtos);
            for (ElementDto dto : dtos) {
                IObject object = (IObject)cache.get(dto.getId());
                if (object == null) continue;
                INodeUtils.updateProperties((IObject)object, PropertiesMapper.dtoToProperties(dto.getProperties(), new PropertyValue[0]), (boolean)false, (boolean)true, (String[])new String[0]);
            }
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
        }
    }

    @Override
    public final void updateRelation(Collection<INodeRelation> relations) {
    }

    protected TypeDescriptor getRelationType() {
        return null;
    }
}

