/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.model.AlignmentHorizontal;
import com.centreon.studio.client.model.AlignmentVertical;
import com.centreon.studio.client.model.Line;
import com.centreon.studio.client.model.ListOfMetricLine;
import com.centreon.studio.client.model.ListOfPos;
import com.centreon.studio.client.model.MetricLine;
import com.centreon.studio.client.model.Pos;
import com.centreon.studio.client.model.StudioColor;
import com.centreon.studio.client.model.StudioFont;
import com.centreon.studio.client.model.Trilean;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.NodeFactories;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.AListPropertySerializer;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.relation.CommonsNodeRelationFactory;
import com.centreon.studio.client.model.relation.INodeRelationFactory;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.utils.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class Activator
implements BundleActivator {
    private static final String PATTERN = "yyyy-MM-dd - HH:mm:ss";

    static {
        new PropertySerializer<String>(String.class){

            public String toObject(String input) {
                return input;
            }
        };
        new PropertySerializer<Boolean>(Boolean.class){

            public Boolean toObject(String input) {
                return Boolean.valueOf(input);
            }
        };
        new PropertySerializer<Trilean>(Trilean.class){

            public Trilean toObject(String input) {
                if (StringUtils.isNullEmptyOrBlank((String)input)) {
                    return null;
                }
                if ("1".equals(input) || Boolean.valueOf(input).booleanValue()) {
                    return Trilean.TRUE;
                }
                if ("0".equals(input) || Boolean.FALSE.toString().equalsIgnoreCase(input)) {
                    return Trilean.FALSE;
                }
                return Trilean.DEFAULT;
            }
        };
        new PropertySerializer<Integer>(Integer.class){

            public Integer toObject(String input) {
                if (input == null) {
                    return null;
                }
                try {
                    return Integer.valueOf(input);
                }
                catch (NumberFormatException e) {
                    if (Configuration.DEBUG) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }
        };
        new PropertySerializer<Long>(Long.class){

            public Long toObject(String input) {
                if (input == null) {
                    return null;
                }
                try {
                    return Long.valueOf(input);
                }
                catch (NumberFormatException e) {
                    if (Configuration.DEBUG) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }
        };
        new PropertySerializer<Double>(Double.class){

            public Double toObject(String input) {
                if (input == null) {
                    return null;
                }
                try {
                    return Double.valueOf(input);
                }
                catch (NumberFormatException e) {
                    if (Configuration.DEBUG) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }

            public String toString(Double input) {
                DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                df.setMaximumFractionDigits(340);
                return df.format(input);
            }
        };
        new PropertySerializer<Date>(Date.class){

            public Date toObject(String input) {
                long value = StringUtils.parseLong((String)input, (long)Long.MIN_VALUE);
                if (value <= 0L) {
                    return null;
                }
                return new Date(value);
            }

            public String toString(Date input) {
                if (input == null) {
                    return null;
                }
                return String.valueOf(input.getTime());
            }
        };
        new PropertySerializer<Pos>(Pos.class){

            public Pos toObject(String input) {
                return Pos.create(input);
            }
        };
        new PropertySerializer<StudioColor>(StudioColor.class){

            public StudioColor toObject(String hexaColor) {
                return StudioColor.fromHexadecimal(hexaColor);
            }

            public String toString(StudioColor color) {
                return color == null ? null : color.toHexadecimal();
            }
        };
        new PropertySerializer<StudioFont>(StudioFont.class){

            public synchronized StudioFont toObject(String formatedFont) {
                return StudioFont.fromFormatedString(formatedFont);
            }

            public String toString(StudioFont font) {
                return font == null ? null : font.toFormatedString();
            }
        };
        new PropertySerializer<TypeDescriptor>(TypeDescriptor.class){

            public TypeDescriptor toObject(String input) {
                return TypeDescriptor.getType((Integer)StringUtils.parseInt((String)input));
            }

            public String toString(TypeDescriptor input) {
                return input.getId().toString();
            }
        };
        new PropertySerializer<Line>(Line.class){

            public Line toObject(String input) {
                Line[] lineArray = Line.values();
                int n = lineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Line line = lineArray[n2];
                    if (line.id.toString().equals(input) || line.oldValue.equals(input)) {
                        return line;
                    }
                    ++n2;
                }
                return null;
            }

            public String toString(Line input) {
                return input.id.toString();
            }
        };
        new PropertySerializer<AlignmentHorizontal>(AlignmentHorizontal.class){

            public AlignmentHorizontal toObject(String input) {
                AlignmentHorizontal[] alignmentHorizontalArray = AlignmentHorizontal.values();
                int n = alignmentHorizontalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AlignmentHorizontal alignement = alignmentHorizontalArray[n2];
                    if (String.valueOf(alignement.getId()).equals(input)) {
                        return alignement;
                    }
                    ++n2;
                }
                return null;
            }

            public String toString(AlignmentHorizontal input) {
                return String.valueOf(input.getId());
            }
        };
        new PropertySerializer<AlignmentVertical>(AlignmentVertical.class){

            public AlignmentVertical toObject(String input) {
                AlignmentVertical[] alignmentVerticalArray = AlignmentVertical.values();
                int n = alignmentVerticalArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AlignmentVertical alignement = alignmentVerticalArray[n2];
                    if (String.valueOf(alignement.getId()).equals(input)) {
                        return alignement;
                    }
                    ++n2;
                }
                return null;
            }

            public String toString(AlignmentVertical input) {
                return String.valueOf(input.getId());
            }
        };
        new PropertyFormatter(Long.class);
        new PropertyFormatter(Line.class);
        new PropertyFormatter(String.class);
        new PropertyFormatter(Integer.class);
        new PropertyFormatter(AlignmentHorizontal.class);
        new PropertyFormatter(AlignmentVertical.class);
        new PropertyFormatter(TypeDescriptor.class);
        new PropertyFormatter<Double>(Double.class){

            public String toString(Double input) {
                if (input == null) {
                    return "";
                }
                return StringUtils.format((Double)input);
            }
        };
        new PropertyFormatter<Pos>(Pos.class){

            public String toString(Pos input) {
                if (input == null) {
                    return "";
                }
                return "(" + StringUtils.format((Double)input.x, (boolean)true) + ";" + StringUtils.format((Double)input.y, (boolean)true) + ")";
            }
        };
        new PropertyFormatter<ListOfPos>(ListOfPos.class){

            public String toString(ListOfPos input) {
                if (input == null || input.isEmpty()) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                for (Pos pos : input) {
                    if (builder.length() > 0) {
                        builder.append(" ");
                    }
                    builder.append(PropertyFormatter.getPropetyFormatter(Pos.class).toString((Object)pos));
                }
                return builder.toString();
            }
        };
        new PropertyFormatter<Boolean>(Boolean.class){

            public String toString(Boolean input) {
                return Boolean.TRUE.equals(input) ? CommonsMessages.keywordYes : CommonsMessages.keywordNo;
            }
        };
        new PropertyFormatter<Date>(Date.class){

            public String toString(Date input) {
                if (input == null) {
                    return "";
                }
                return new SimpleDateFormat(Activator.PATTERN).format(input);
            }
        };
        new PropertyFormatter<Color>(Color.class){

            public String toColor(Color input) {
                return this.toString(input);
            }

            public String toString(Color color) {
                if (color == null) {
                    return "";
                }
                StudioColor studioColor = StudioRegistries.colorRegistry().getStudioColorFrom(color.getRGB());
                return studioColor.toHexadecimal();
            }
        };
        new PropertyFormatter<StudioColor>(StudioColor.class){

            public String toString(StudioColor color) {
                return color.toHexadecimal();
            }
        };
        new PropertyFormatter<StudioFont>(StudioFont.class){

            public String toString(StudioFont font) {
                return font.toFormatedString();
            }
        };
        new PropertyFormatter<Font>(Font.class){

            public String toString(Font font) {
                if (font == null) {
                    return "";
                }
                return font.getFontData()[0].getName();
            }
        };
        new AListPropertySerializer<Pos, ListOfPos>(ListOfPos.class, AListPropertySerializer.ConcreteInstance.DEFAULT){

            protected Pos createElement(String part) {
                return Pos.create(part);
            }
        };
        new ListOfMetricLineSerializer();
        new PropertySerializer<INode>(INode.class){

            public INode toObject(String input) {
                TypeDescriptor type;
                Long id;
                block6: {
                    String[] parts;
                    block5: {
                        parts = input.split("/");
                        if (parts.length != 2) {
                            return null;
                        }
                        try {
                            id = Long.valueOf(parts[0]);
                            if (id != null) break block5;
                            return null;
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    Integer typeId = Integer.valueOf(parts[1]);
                    type = TypeDescriptor.getType((Integer)typeId);
                    if (type != null) break block6;
                    return null;
                }
                return NodeFactories.INSTANCE.create(type, id, null, null);
            }

            public String toString(INode input) {
                StringBuilder builder = new StringBuilder();
                builder.append(input.getId());
                builder.append("/");
                builder.append(input.getType().getId());
                return builder.toString();
            }
        };
    }

    public void start(BundleContext bundleContext) {
        NodeRelationFactories.INSTANCE.register((INodeRelationFactory)CommonsNodeRelationFactory.INSTANCE);
    }

    public void stop(BundleContext bundleContext) {
    }

    public static class ListOfMetricLineSerializer
    extends AListPropertySerializer<MetricLine, ListOfMetricLine> {
        public ListOfMetricLineSerializer() {
            super(ListOfMetricLine.class, AListPropertySerializer.ConcreteInstance.LIST_OF_METRIC_LINE);
        }

        protected MetricLine createElement(String part) {
            String[] values = part.split(",");
            String label = values[0];
            String style = values[1];
            int size = Integer.parseInt(values[2]);
            String color = values[3];
            boolean isVisible = Boolean.valueOf(values[4]);
            MetricLine.MetricLineBuilder mlb = new MetricLine.MetricLineBuilder(label);
            mlb.setStyle(style).setSize(size).setColor(color).setVisible(isVisible);
            return mlb.build();
        }
    }
}

