/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons;

import com.centreon.studio.client.utils.StringUtils;
import java.io.File;

public class Configuration {
    public static final String DOC_URL = "https://documentation.centreon.com/docs/centreon-map-4/en/latest/";
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultReadTimeout";
    private static final String HOME_FOLDER_NAME = "Centreon-Map4";
    private static final String OSGI_INSTANCE_AREA = System.getProperty("osgi.instance.area");
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String DEBUG_PROPERTY = "debug";
    private static final String SKIP_GZIP_PROPERTY = "skpi.gzip";
    private static final String CLEAN_MODE_PROPERTY = "clean.mode";
    private static final String CLEAN_SIZE_PROPERTY = "clean.size";
    private static final String SYNC_DELAY_PROPERTY = "sync.delay";
    private static final String BATCH_DELAY_PROPERTY = "batch.delay";
    private static final String READ_TIMEOUT_PROPERTY = "read.timeout";
    private static final String CONNECT_TIMEOUT_PROPERTY = "connect.timeout";
    private static final String MAX_MEDIA_LENGHT_PROPERTY = "max.media.length";
    private static final String UNDO_QUEUE_SIZE_PROPERTY = "actions.undo.queue.size";
    public static final String CLEAN_MODE_NONE = "none";
    public static final String CLEAN_MODE_SIZE = "size";
    public static final String CLEAN_MODE_ALL = "all";
    private static final String DEFAULT_CLEAN_MODE = "all";
    private static final int DEFAULT_SYNC_DELAY = 1000;
    private static final int DEFAULT_BATCH_DELAY = 100;
    private static final int DEFAULT_CLEAN_SIZE = 100;
    private static final int DEFAULT_QUEUE_SIZE = 10;
    private static final int DEFAULT_READ_TIMEOUT = 60;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10;
    private static final int DEFAULT_MAX_MEDIA_LENGTH = 3;
    public static final File APPLI_HOME;
    public static final String CLEAN_MODE;
    public static final boolean DEBUG;
    public static final boolean SKIP_GZIP;
    public static final int SYNC_DELAY;
    public static final int BATCH_DELAY;
    public static final int MEDIA_CACHE_SIZE;
    public static final int ACTION_UNDO_QUEUE_SIZE;
    public static final int MAX_MEDIA_LENGTH;

    static {
        DEBUG = Boolean.parseBoolean(System.getProperty(DEBUG_PROPERTY));
        SKIP_GZIP = Boolean.parseBoolean(System.getProperty(SKIP_GZIP_PROPERTY));
        SYNC_DELAY = Math.max(1000, StringUtils.parseInt((String)System.getProperty(SYNC_DELAY_PROPERTY), (int)0));
        BATCH_DELAY = Math.max(100, StringUtils.parseInt((String)System.getProperty(BATCH_DELAY_PROPERTY), (int)0));
        ACTION_UNDO_QUEUE_SIZE = Math.max(10, StringUtils.parseInt((String)System.getProperty(UNDO_QUEUE_SIZE_PROPERTY), (int)0));
        MEDIA_CACHE_SIZE = Math.max(100, StringUtils.parseInt((String)System.getProperty(CLEAN_SIZE_PROPERTY), (int)0)) * 1024 * 1024;
        MAX_MEDIA_LENGTH = StringUtils.parseInt((String)System.getProperty(MAX_MEDIA_LENGHT_PROPERTY), (int)3) * 1024 * 1024;
        String cleanMode = System.getProperty(CLEAN_MODE_PROPERTY);
        CLEAN_MODE = "all".equals(cleanMode) || CLEAN_MODE_SIZE.equals(cleanMode) || CLEAN_MODE_NONE.equals(cleanMode) ? cleanMode : "all";
        int connectTimeout = Math.max(0, StringUtils.parseInt((String)System.getProperty(CONNECT_TIMEOUT_PROPERTY), (int)10)) * 1000;
        int readTimeout = Math.max(0, StringUtils.parseInt((String)System.getProperty(READ_TIMEOUT_PROPERTY), (int)60)) * 1000;
        System.setProperty(JRE_CONNECT_TIMEOUT_PROPERTY, String.valueOf(connectTimeout));
        System.setProperty(JRE_READ_TIMEOUT_PROPERTY, String.valueOf(readTimeout));
        String fileName = OSGI_INSTANCE_AREA != null ? OSGI_INSTANCE_AREA.replaceAll("file:", "") : String.valueOf(USER_HOME) + File.separator + HOME_FOLDER_NAME;
        APPLI_HOME = new File(fileName);
        if (!APPLI_HOME.exists() && !APPLI_HOME.mkdirs()) {
            System.err.println("cannot create appli home dirs");
        }
    }

    private Configuration() {
    }
}

