/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertySerializer;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.map.commons.PropertyDto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PropertiesMapper {
    private static final String RESOURCE_NAME = "resourceName";
    private static final Collection<String> PROPERTIES_TO_REMOVE = new HashSet<String>();
    private static final Map<String, String> PROPERTIES_TO_REPLACE_MAPPING = new HashMap<String, String>(){
        private static final long serialVersionUID = 3175324972651453189L;

        @Override
        public String get(Object key) {
            String result = (String)super.get(key);
            if (result == null) {
                return key.toString();
            }
            return result;
        }
    };
    private static final Map<String, String> PREFIX_TO_CATEGORY;
    private static final Set<String> FORBIDDEN_STRINGS;
    private static final Set<String> PREFIX_TO_CREATE;
    private static final Set<String> NOT_FOUND;

    static {
        PROPERTIES_TO_REPLACE_MAPPING.put("name", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("sgName", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("hgName", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("metaName", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("hostName", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("serviceDescription", RESOURCE_NAME);
        PROPERTIES_TO_REPLACE_MAPPING.put("activate", PropertyDescriptors.ACTIVE.id);
        PROPERTIES_TO_REPLACE_MAPPING.put("desc", PropertyDescriptors.DESCRIPTION.id);
        PROPERTIES_TO_REPLACE_MAPPING.put("connectionLine", PropertyDescriptors.LINE.id);
        PROPERTIES_TO_REPLACE_MAPPING.put("connectionThickness", PropertyDescriptors.THICKNESS.id);
        PROPERTIES_TO_REMOVE.add("containerId");
        PREFIX_TO_CATEGORY = new HashMap<String, String>(2);
        PREFIX_TO_CATEGORY.put("macro_$_HOST", "Macro");
        PREFIX_TO_CATEGORY.put("macro_$_SERVICE", "Macro");
        FORBIDDEN_STRINGS = new HashSet<String>(1);
        FORBIDDEN_STRINGS.add("$");
        PREFIX_TO_CREATE = new HashSet<String>();
        PREFIX_TO_CREATE.add("url");
        PREFIX_TO_CREATE.add("count");
        PREFIX_TO_CREATE.add("server");
        PREFIX_TO_CREATE.add("license");
        PREFIX_TO_CREATE.add("centreon");
        NOT_FOUND = new HashSet<String>(10);
    }

    public static Collection<PropertyValue> dtoToProperties(List<PropertyDto> list, PropertyValue ... values) {
        if (list == null || list.isEmpty()) {
            ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(values.length);
            PropertyValue[] propertyValueArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyValue p = propertyValueArray[n2];
                properties.add(p);
                ++n2;
            }
            return properties;
        }
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>(list.size() + values.length);
        properties.addAll(Arrays.asList(values));
        for (PropertyDto propertyDto : list) {
            String prefix;
            if (PROPERTIES_TO_REMOVE.contains(propertyDto.getKey())) continue;
            String propertyId = PROPERTIES_TO_REPLACE_MAPPING.get(propertyDto.getKey());
            PropertyDescriptor propertyDescriptor = PropertyDescriptor.getPropertyDescriptor((String)propertyId);
            if (propertyDescriptor == null && propertyId.contains(".") && PREFIX_TO_CREATE.contains(prefix = propertyId.substring(0, propertyId.indexOf(".")))) {
                propertyDescriptor = new PropertyDescriptor(propertyId, propertyId, String.class, (Object)"", true);
            }
            if (propertyDescriptor != null) {
                PropertySerializer ps = PropertySerializer.getPropertySerializer((Class)propertyDescriptor.clazz);
                if (ps != null) {
                    properties.add(PropertyValue.unchecked((PropertyDescriptor)propertyDescriptor, (Object)ps.toObject(propertyDto.getValue())));
                    continue;
                }
                if (!Configuration.DEBUG || NOT_FOUND.contains(propertyDto.getKey())) continue;
                System.err.println("ERROR : didnt find any PropertySerializer for property : " + propertyDto.getKey());
                NOT_FOUND.add(propertyDto.getKey());
                continue;
            }
            PropertyValue value = PropertiesMapper.createCustomPropertyDescriptor(propertyId, propertyDto.getValue());
            if (value != null) {
                properties.add(value);
                continue;
            }
            if (!Configuration.DEBUG) continue;
            System.err.println("ERROR : couldnt create custom PropertySerializer for property : " + propertyDto.getKey());
        }
        return properties;
    }

    public static List<PropertyDto> propertiesToDtos(Collection<PropertyValue> values) {
        ArrayList<PropertyDto> propertiesDto = new ArrayList<PropertyDto>(values.size());
        for (PropertyValue entry : values) {
            if (entry.getProperty().isLocal) continue;
            Class propertyClazz = entry.getProperty().clazz;
            PropertySerializer ps = PropertySerializer.getPropertySerializer((Class)propertyClazz);
            if (ps != null) {
                PropertyDto propertyDto = new PropertyDto();
                propertyDto.setKey(entry.getProperty().id);
                propertyDto.setValue(ps.toString(entry.getValue()));
                propertiesDto.add(propertyDto);
                continue;
            }
            if (!Configuration.DEBUG) continue;
            System.err.println("ERROR : didnt find any PropertySerializer for property : " + propertyClazz);
        }
        return propertiesDto;
    }

    private static PropertyValue createCustomPropertyDescriptor(String propertyId, String value) {
        for (Map.Entry<String, String> entry : PREFIX_TO_CATEGORY.entrySet()) {
            if (!propertyId.startsWith(entry.getKey())) continue;
            String actualId = propertyId.substring(entry.getKey().length());
            for (String forbidden : FORBIDDEN_STRINGS) {
                actualId = actualId.replace(forbidden, "");
            }
            PropertyDescriptor propertyDescriptor = PropertyDescriptor.getPropertyDescriptor((String)actualId);
            if (propertyDescriptor != null) {
                PropertySerializer ps = PropertySerializer.getPropertySerializer((Class)propertyDescriptor.clazz);
                if (ps == null) continue;
                return PropertyValue.unchecked((PropertyDescriptor)propertyDescriptor, (Object)ps.toObject(value));
            }
            propertyDescriptor = new PropertyDescriptor(actualId, actualId, entry.getValue(), String.class, (Object)"", true);
            return PropertyValue.unchecked((PropertyDescriptor)propertyDescriptor, (Object)value);
        }
        if (Configuration.DEBUG) {
            System.err.println("ERROR : couldnt find pattern for property : " + propertyId);
        }
        return null;
    }

    private PropertiesMapper() {
    }
}

