/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.dialogs;

import com.centreon.studio.client.commons.messages.CommonsMessages;
import com.centreon.studio.client.commons.swt.SWTUtils;
import javax.xml.ws.Holder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class MessageDialogUtils {
    private static final String INFO = CommonsMessages.keywordInfo;
    private static final String ERROR = CommonsMessages.keywordError;
    private static final String CONFIRM = CommonsMessages.keywordConfirm;
    private static final String QUESTION = CommonsMessages.keywordQuestion;

    public static boolean openConfirm(String message) {
        Holder confirmed = new Holder((Object)false);
        MessageDialogUtils.run(() -> {
            Object object = holder.value = Boolean.valueOf(MessageDialog.openConfirm((Shell)SWTUtils.getDisplay().getActiveShell(), (String)CONFIRM, (String)message));
        }, true);
        return (Boolean)confirmed.value;
    }

    public static void openError(String message) {
        MessageDialogUtils.run(() -> MessageDialog.openError((Shell)SWTUtils.getDisplay().getActiveShell(), (String)ERROR, (String)message), false);
    }

    public static void openInformation(String message) {
        MessageDialogUtils.run(() -> MessageDialog.openInformation((Shell)SWTUtils.getDisplay().getActiveShell(), (String)INFO, (String)message), true);
    }

    public static boolean openQuestion(String message) {
        Holder confirmed = new Holder((Object)false);
        MessageDialogUtils.run(() -> {
            Object object = holder.value = Boolean.valueOf(MessageDialog.openQuestion((Shell)SWTUtils.getDisplay().getActiveShell(), (String)QUESTION, (String)message));
        }, true);
        return (Boolean)confirmed.value;
    }

    private static void run(Runnable runnable, boolean syncExec) {
        Display d = SWTUtils.getDisplay();
        if (Thread.currentThread() != d.getThread()) {
            if (syncExec) {
                d.syncExec(runnable);
            } else {
                d.asyncExec(runnable);
            }
        } else {
            runnable.run();
        }
    }

    private MessageDialogUtils() {
    }
}

