/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.validation.field;

import com.centreon.studio.client.commons.jface.validation.ControlValidators;
import com.centreon.studio.client.commons.jface.validation.field.IField;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.commons.swt.SWTUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public abstract class AField<C extends Control, V>
implements IField<C, V>,
DisposeListener,
Listener {
    private static final String MODIFIED_MESSAGE = "this value has been modified";
    private static final int BOTTOM = 17408;
    private static final int TOP = 16512;
    protected final C control;
    protected V value;
    private final ControlValidators.IControlValidator<C> validator;
    private final IForm form;
    private Label label;
    private boolean notifyChange;
    private ControlDecoration topDecoration;
    private ControlDecoration bottomDecoration;

    private static void register(Control control, Listener listener) {
        control.addListener(9, listener);
        control.addListener(24, listener);
        control.addListener(15, listener);
        control.addListener(13, listener);
    }

    protected AField(C control, String label, V value, IForm form, ControlValidators.IControlValidator<C> validator) {
        this.form = form;
        this.value = value;
        this.control = control;
        if (label != null) {
            this.label = SWTUtils.createLabel(control.getParent(), label);
            this.label.moveAbove(this.control);
        }
        this.resetDefault();
        this.validator = validator;
        if (validator != null) {
            this.bottomDecoration = new ControlDecoration(control, 17408, control.getParent());
            this.bottomDecoration.hide();
            this.topDecoration = new ControlDecoration(control, 16512, control.getParent());
            this.topDecoration.setDescriptionText(MODIFIED_MESSAGE);
            this.topDecoration.setImage(ControlValidators.IMAGE_INFO);
            this.topDecoration.hide();
        }
        AField.register(control, this);
        this.control.addDisposeListener((DisposeListener)this);
    }

    @Override
    public C getControl() {
        return this.control;
    }

    @Override
    public final Label getLabel() {
        return this.label;
    }

    public void handleEvent(Event event) {
        if (this.form != null) {
            this.form.setChange((Control)this.control, this.hasChanged());
            this.form.setValidation((Control)this.control, this.validate());
        }
        if (this.validator != null) {
            if (this.validate()) {
                this.bottomDecoration.hide();
            } else {
                this.bottomDecoration.setDescriptionText(this.validator.getMessage());
                this.bottomDecoration.setImage(this.validator.getImage());
                this.bottomDecoration.show();
            }
            if (this.hasChanged() && this.notifyChange) {
                this.topDecoration.show();
            } else {
                this.topDecoration.hide();
            }
        }
    }

    @Override
    public void setValue(V value) {
        Assert.isNotNull(value, (String)"value must not be null");
        this.value = value;
        this.resetDefault();
        this.handleEvent(null);
    }

    @Override
    public boolean validate() {
        if (this.validator == null) {
            return true;
        }
        return this.validator.validate(this.control);
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.getLabel() != null && !this.getLabel().isDisposed()) {
            this.getLabel().dispose();
        }
    }

    protected final boolean checkControl() {
        return this.getControl() != null && !this.getControl().isDisposed();
    }
}

