/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.jface.validation.field.impl;

import com.centreon.studio.client.commons.jface.StudioRegistries;
import com.centreon.studio.client.commons.jface.validation.field.AField;
import com.centreon.studio.client.commons.jface.validation.form.IForm;
import com.centreon.studio.client.model.StudioColor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;

public class ColorField
extends AField<Button, Color> {
    private final ColorSelector selector;

    public ColorField(ColorSelector selector, String label, Color value, IForm form) {
        super(selector.getButton(), label, value, form, null);
        this.selector = selector;
        this.resetDefault();
    }

    @Override
    public Color getValue() {
        if (!this.checkControl()) {
            return null;
        }
        RGB rgb = this.selector.getColorValue();
        StudioColor studioColor = StudioRegistries.colorRegistry().getStudioColorFrom(rgb);
        return StudioRegistries.colorRegistry().getSWTColorFrom(studioColor);
    }

    @Override
    public boolean hasChanged() {
        RGB rgb = this.selector.getColorValue();
        return !rgb.equals((Object)((Color)this.value).getRGB());
    }

    @Override
    public void resetDefault() {
        if (this.selector != null) {
            this.selector.setColorValue(((Color)this.value).getRGB());
        }
    }
}

