/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.commons.swt;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class MoveShellListener
extends MouseAdapter
implements MouseMoveListener {
    private boolean isDraged;
    private int x;
    private int y;
    private final Shell shell;

    public MoveShellListener(Shell shell) {
        this.shell = shell;
        this.addListener((Composite)shell);
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.isDraged = true;
            this.x = e.x;
            this.y = e.y;
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.isDraged) {
            int deltaX = this.x - e.x;
            int deltaY = this.y - e.y;
            Rectangle bounds = this.shell.getBounds();
            this.shell.setBounds(bounds.x - deltaX, bounds.y - deltaY, bounds.width, bounds.height);
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1) {
            this.isDraged = false;
        }
    }

    private void addListener(Composite control) {
        control.addMouseListener((MouseListener)this);
        control.addMouseMoveListener((MouseMoveListener)this);
        Composite composite = control;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                this.addListener((Composite)child);
            }
            ++n2;
        }
    }
}

