/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.repository;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.threads.ThreadDelayer;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.object.ObjectDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoteRepositoryStrategy
extends ARepositoryStrategy
implements Runnable {
    private final Set<INode> objectToProperties;
    private final Set<INodeRelation> relationsToProperties;
    private final Map<INode, Collection<INodeRelation>> nodeToRelationsRemove;
    private final Map<INode, Collection<INodeRelation>> nodeToRelationsAdd;
    private final IWebService service;
    private ThreadDelayer threadDelayer;

    private static final <T> Collection<T> copy(Collection<T> toCopy) {
        ArrayList<T> copy = new ArrayList<T>(toCopy);
        toCopy.clear();
        return copy;
    }

    private static final Map<INode, Collection<INodeRelation>> copy(Map<INode, Collection<INodeRelation>> toCopy) {
        HashMap<INode, Collection<INodeRelation>> copy = new HashMap<INode, Collection<INodeRelation>>(toCopy);
        toCopy.clear();
        return copy;
    }

    private static Collection<INodeRelation> nonLocalRelations(Collection<INodeRelation> relations) {
        ArrayList<INodeRelation> nonLocalRelations = new ArrayList<INodeRelation>(relations.size());
        Iterator<INodeRelation> it = relations.iterator();
        while (it.hasNext()) {
            INodeRelation next = it.next();
            if (next.getType().isLocal() || next.getTarget().getType().isLocal()) continue;
            nonLocalRelations.add(next);
            it.remove();
        }
        return nonLocalRelations;
    }

    public RemoteRepositoryStrategy(IWebService service) {
        this.service = service;
        this.objectToProperties = new HashSet<INode>(32);
        this.relationsToProperties = new HashSet<INodeRelation>(32);
        this.nodeToRelationsRemove = new HashMap<INode, Collection<INodeRelation>>(32);
        this.nodeToRelationsAdd = new HashMap<INode, Collection<INodeRelation>>(32);
    }

    public synchronized void addPropertyValues(ObjectDecorator decorator, Collection<PropertyValue> propertyValues) {
        if (decorator.getType().isLocal()) {
            return;
        }
        boolean local = true;
        for (PropertyValue propertyValue : propertyValues) {
            if (propertyValue.getProperty().isLocal) continue;
            local = false;
            break;
        }
        if (local) {
            return;
        }
        INodeRelation relation = (INodeRelation)decorator.adapt(INodeRelation.class);
        if (relation != null) {
            if (relation.getTarget().getType().isLocal()) {
                return;
            }
            this.relationsToProperties.add(relation);
        } else {
            this.objectToProperties.add((INode)decorator.adapt(INode.class));
        }
        this.scheddule();
    }

    public synchronized void addRelations(NodeDecorator decorator, Collection<INodeRelation> relations) {
        Collection<INodeRelation> nonLocalRelations = RemoteRepositoryStrategy.nonLocalRelations(relations);
        if (nonLocalRelations.isEmpty()) {
            return;
        }
        INode node = (INode)decorator.adapt(INode.class);
        Collection<INodeRelation> nodesRelations = this.nodeToRelationsAdd.get(node);
        if (nodesRelations == null) {
            nodesRelations = new ArrayList<INodeRelation>(nonLocalRelations.size());
            this.nodeToRelationsAdd.put(node, nodesRelations);
        }
        nodesRelations.addAll(nonLocalRelations);
        this.scheddule();
    }

    public synchronized void removeRelations(NodeDecorator decorator, Collection<INodeRelation> relations) {
        Collection<INodeRelation> nonLocalRelations = RemoteRepositoryStrategy.nonLocalRelations(relations);
        if (nonLocalRelations.isEmpty()) {
            return;
        }
        INode node = (INode)decorator.adapt(INode.class);
        Collection<INodeRelation> nodesRelations = this.nodeToRelationsRemove.get(node);
        if (nodesRelations == null) {
            nodesRelations = new ArrayList<INodeRelation>(nonLocalRelations.size());
            this.nodeToRelationsRemove.put(node, nodesRelations);
        }
        nodesRelations.addAll(nonLocalRelations);
        this.scheddule();
    }

    @Override
    public void run() {
        this.threadDelayer = null;
        if (!this.objectToProperties.isEmpty()) {
            this.service.update(RemoteRepositoryStrategy.copy(this.objectToProperties));
        }
        if (!this.relationsToProperties.isEmpty()) {
            this.service.updateRelation(RemoteRepositoryStrategy.copy(this.relationsToProperties));
        }
        if (!this.nodeToRelationsAdd.isEmpty()) {
            this.service.create(RemoteRepositoryStrategy.copy(this.nodeToRelationsAdd));
        }
        if (!this.nodeToRelationsRemove.isEmpty()) {
            this.service.remove(RemoteRepositoryStrategy.copy(this.nodeToRelationsRemove));
        }
    }

    private void scheddule() {
        if (this.threadDelayer == null || !this.threadDelayer.isAlive()) {
            this.threadDelayer = new ThreadDelayer("RemoteRepositoryStrategy ThreadDelayer", (Runnable)this, Configuration.BATCH_DELAY);
            this.threadDelayer.start();
        } else {
            this.threadDelayer.requireRedelay();
        }
    }
}

