/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.decoration.repository;

import com.centreon.studio.client.model.ISorter;
import com.centreon.studio.client.model.decoration.node.NodeDecorator;
import com.centreon.studio.client.model.decoration.repository.ARepositoryStrategy;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.IPropertiesListener;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyDescriptor;
import com.centreon.studio.client.model.properties.PropertyFormatter;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.CollectionsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class SortRepositoryStrategy
extends ARepositoryStrategy
implements ISorter<INodeRelation> {
    private static final long serialVersionUID = 7503977125382448178L;
    public static final PropertyDescriptor<PropertyDescriptor> SORTING_PROPERTY = new PropertyDescriptor("sortingProperty", "sortingPropertyLabel", PropertyDescriptor.class, (Object)AObject.LABEL, true);
    public static final PropertyDescriptor<Integer> SORTING_ORDER = new PropertyDescriptor("sortingOrder", "sortingOrderLabel", Integer.class, (Object)1, true);
    private final Collection<PropertyDescriptor<?>> candidateProperties;
    private final Collection<IPropertiesListener> listeners;
    private int sortingOrder = 1;
    private PropertyDescriptor<?> sortingProperty = AObject.LABEL;
    private NodeDecorator root;

    public SortRepositoryStrategy(PropertyDescriptor<?> ... candidateProperties) {
        Assert.isTrue((candidateProperties != null ? 1 : 0) != 0, (String)"candidate properties must not be null");
        this.listeners = new LinkedList<IPropertiesListener>();
        this.candidateProperties = Arrays.asList(candidateProperties);
    }

    @Override
    public int compare(INodeRelation o1, INodeRelation o2) {
        String s2;
        String s1;
        if (this.sortingProperty == AObject.LABEL) {
            s1 = o1.getTarget().getLabel();
            s2 = o2.getTarget().getLabel();
        } else {
            PropertyFormatter formatter = PropertyFormatter.getPropetyFormatter((Class)this.sortingProperty.clazz);
            if (formatter != null) {
                s1 = formatter.toString(o1.getTarget().getProperty(this.sortingProperty));
                s2 = formatter.toString(o2.getTarget().getProperty(this.sortingProperty));
            } else {
                Object v1 = o1.getTarget().getProperty(this.sortingProperty);
                Object v2 = o2.getTarget().getProperty(this.sortingProperty);
                s1 = v1 == null ? null : v1.toString();
                String string = s2 = v2 == null ? null : v2.toString();
            }
        }
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareToIgnoreCase(s2) * this.sortingOrder;
    }

    @Override
    public Collection<PropertyDescriptor<?>> getCandidateProperties() {
        return this.candidateProperties;
    }

    public void registerPropertiesListener(IPropertiesListener listener) {
        this.listeners.add(listener);
    }

    public void relationsAdded(NodeDecorator decorator, Collection<INodeRelation> relations) {
        HashSet<TypeDescriptor> typesToSort = new HashSet<TypeDescriptor>(8);
        for (INodeRelation relation : relations) {
            typesToSort.add(relation.getType());
        }
        for (TypeDescriptor type : typesToSort) {
            List typedRelations = (List)decorator.getInternalRelations().get(type);
            CollectionsUtils.sort((List)typedRelations, (Comparator)this);
        }
    }

    public void setRoot(NodeDecorator root) {
        this.root = root;
    }

    @Override
    public void setSortingValues(int sortingOrder, PropertyDescriptor<?> sortingProperty) {
        int actualOrder;
        Assert.isNotNull(sortingProperty, (String)"sorting property must not be null");
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(2);
        if (this.sortingProperty != sortingProperty) {
            this.sortingProperty = sortingProperty;
            propertyValues.add(new PropertyValue(SORTING_PROPERTY, sortingProperty));
        }
        int n = actualOrder = sortingOrder == 1024 || sortingOrder < 0 ? -1 : 1;
        if (this.sortingOrder != actualOrder) {
            this.sortingOrder = actualOrder;
            propertyValues.add(new PropertyValue(SORTING_ORDER, (Object)actualOrder));
        }
        if (!propertyValues.isEmpty()) {
            this.sendEvent(propertyValues);
            this.recursiveSort(this.root);
        }
    }

    public void unregisterPropertiesListener(IPropertiesListener listener) {
        this.listeners.remove(listener);
    }

    private void recursiveSort(NodeDecorator input) {
        for (List typedRelations : input.getInternalRelations().values()) {
            for (INodeRelation relation : typedRelations) {
                this.recursiveSort((NodeDecorator)relation.getTarget());
            }
            CollectionsUtils.sort((List)typedRelations, (Comparator)this);
            input.sendAddedEvent(Collections.emptyList());
        }
    }

    private void sendEvent(Collection<PropertyValue> propertyValues) {
        for (IPropertiesListener listener : this.listeners) {
            listener.propertiesChanged(null, propertyValues);
        }
    }
}

