/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.model.relation;

import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.AObject;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StringUtils;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public class NodeRelation
extends AObject
implements INodeRelation {
    private final INode source;
    private final INode target;

    protected NodeRelation(TypeDescriptor type, INode source, INode target) {
        this(type, SequenceUtils.next(), source, target, null);
    }

    protected NodeRelation(TypeDescriptor type, Long id, INode source, INode target) {
        this(type, id, source, target, null);
    }

    protected NodeRelation(TypeDescriptor type, Long id, INode source, INode target, Collection<PropertyValue> properties) {
        super(type, id, properties, source.getRepository());
        this.source = (INode)source.adapt(INode.class);
        this.target = (INode)target.adapt(INode.class);
        Assert.isTrue((this.source != this.target ? 1 : 0) != 0, (String)"source and target must not be the same");
    }

    public INode getSource() {
        return this.source;
    }

    public INode getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getSimpleName());
        builder.append(" [type=");
        builder.append(this.getType());
        builder.append(", id=");
        builder.append(this.getId());
        builder.append("]");
        builder.append(StringUtils.NEW_LINE);
        builder.append("\tsource=");
        builder.append(this.source);
        builder.append(StringUtils.NEW_LINE);
        builder.append("\ttarget=");
        builder.append(this.target);
        return builder.toString();
    }
}

