/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.client.acl;

import com.centreon.studio.client.acl.ACLRepositoryDecorator;
import com.centreon.studio.client.acl.ACLSyncEventHandler;
import com.centreon.studio.client.acl.ACLTypes;
import com.centreon.studio.client.acl.ACLUtils;
import com.centreon.studio.client.acl.ACLWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.repository.IRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ACLAddon
extends AuthenticationEventHandler {
    private final ACLSyncEventHandler aclSyncHandler;
    private final IRepository repository;
    private final ACLWebService service;
    private final ACLUtils utils;

    @Inject
    public ACLAddon(ACLRepositoryDecorator repository, ACLWebService service, ACLUtils utils) {
        this.utils = utils;
        this.service = service;
        this.repository = (IRepository)repository.adapt(IRepository.class);
        this.aclSyncHandler = new ACLSyncEventHandler(this.repository, service, utils);
        utils.register(ACLTypes.ADMIN);
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this);
        eventManager.subscribe("studio/sync", true, (StudioEventHandler)this.aclSyncHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"ACL addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.unsubscribe((StudioEventHandler)this.aclSyncHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"ACL addon destroyed", (Object[])new Object[0]));
    }

    protected void loggedIn() {
        this.loadACLRepository();
    }

    protected void loggedOut() {
        this.clearACLRepository();
    }

    private void clearACLRepository() {
        this.repository.setSelection((Object)this, null);
        this.repository.removeRelations((Collection)this.repository.getRelations(new TypeDescriptor[0]));
    }

    private void loadACLRepository() {
        this.repository.addRelations(this.retrieveACLRelations());
    }

    private Collection<INodeRelation> retrieveACLRelations() {
        List<INodeRelation> relations = this.service.getRelationsByIds(Collections.emptyList());
        ArrayList<INode> aclGroups = new ArrayList<INode>(relations.size());
        for (INodeRelation relation : relations) {
            if (relation.getType() != ACLTypes.ACL_GROUP) continue;
            aclGroups.add(relation.getTarget());
        }
        Map<INode, Collection<INodeRelation>> aclGroupToAclRules = this.service.getAclRules(aclGroups, this.utils.getTypesUnderACL());
        for (Map.Entry<INode, Collection<INodeRelation>> aclGroupToAclRule : aclGroupToAclRules.entrySet()) {
            aclGroupToAclRule.getKey().addRelations(aclGroupToAclRule.getValue());
        }
        return relations;
    }
}

