/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.resources.bam;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.StudioEventHandler;
import com.centreon.studio.client.events.auth.AuthenticationEventHandler;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.ui.part.APart;
import com.centreon.studio.map.client.resources.bam.BAMResourceSyncEventHandler;
import com.centreon.studio.map.client.resources.bam.BAMResourceWebService;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.bam.model.repository.BARepository;
import com.centreon.studio.map.client.resources.bam.model.repository.KPIRepository;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import com.centreon.studio.map.client.resources.model.ui.ResourcePart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class BAMResourceAddon
extends BAMResourceSyncEventHandler {
    private final AuthenticationEventHandler authenticationEventHandler;

    @Inject
    public BAMResourceAddon(final BARepository baRepository, final KPIRepository kpiRepository, final BAMResourceWebService service, ResourceRepositoryDecorator resourceRepository, final BrokerEventManager eventManager) {
        super(baRepository, service, resourceRepository);
        this.authenticationEventHandler = new AuthenticationEventHandler(){

            protected void loggedIn() {
                eventManager.sync((StudioEvent)LogEvent.trace(BAMResourceAddon.class, (String)"Load model BA", (Object[])new Object[0]));
                long timeBeforeService = System.currentTimeMillis();
                List<INodeRelation> relations = service.getRelationsByIds(Collections.emptyList());
                eventManager.sync((StudioEvent)LogEvent.trace(BAMResourceAddon.class, (String)"Retrieved {} relations from the server - time\u00a0{} ms", (Object[])new Object[]{relations.size(), System.currentTimeMillis() - timeBeforeService}));
                ArrayList<INodeRelation> relationsToAdd = new ArrayList<INodeRelation>(relations.size());
                for (INodeRelation relation : relations) {
                    INode oldBa = BAMResourceAddon.this.resourceIndexer.getNode(BAMResourceTypes.RESOURCE_BA, relation.getTarget().getId());
                    if (oldBa != null) {
                        INodeUtils.performDelta((INode)oldBa, (INode)relation.getTarget(), (boolean)true, (boolean)true, (boolean)true, (boolean)false);
                        continue;
                    }
                    relationsToAdd.add(relation);
                }
                long timeBeforeAddRelations = System.currentTimeMillis();
                Collection addedRelations = baRepository.addRelations(relationsToAdd);
                eventManager.sync((StudioEvent)LogEvent.trace(BAMResourceAddon.class, (String)"Added {} relations to BA repository - time={} ms", (Object[])new Object[]{addedRelations.size(), System.currentTimeMillis() - timeBeforeAddRelations}));
                ResourcePart resourcePart = (ResourcePart)APart.retrieve(ResourcePart.class);
                if (resourcePart != null) {
                    resourcePart.refreshViewer();
                }
            }

            protected void loggedOut() {
                kpiRepository.removeRelations(kpiRepository.getRelations(new TypeDescriptor[0]));
                baRepository.removeRelations(baRepository.getRelations(new TypeDescriptor[0]));
                kpiRepository.setSelection((Object)this, null);
                baRepository.setSelection((Object)this, null);
            }
        };
    }

    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager) {
        eventManager.subscribe("studio/sync", true, (StudioEventHandler)this);
        eventManager.subscribe("studio/authentication", true, (StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"BAM Resources addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager) {
        eventManager.unsubscribe((StudioEventHandler)this);
        eventManager.unsubscribe((StudioEventHandler)this.authenticationEventHandler);
        eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)"BAM Resources addon destroyed", (Object[])new Object[0]));
    }
}

