/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.resources.bam;

import com.centreon.studio.client.events.sync.SyncEvent;
import com.centreon.studio.client.events.sync.SyncEventHandler;
import com.centreon.studio.client.model.decoration.IIndexer;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.map.client.resources.bam.BAMResourceWebService;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.bam.model.repository.BARepository;
import com.centreon.studio.map.client.resources.model.repository.decorators.ResourceRepositoryDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BAMResourceSyncEventHandler
extends SyncEventHandler {
    private final BAMResourceWebService service;
    private final BARepository baRepository;
    protected final IIndexer resourceIndexer;

    public BAMResourceSyncEventHandler(BARepository baRepository, BAMResourceWebService service, ResourceRepositoryDecorator resourceRepository) {
        super(Arrays.asList(BAMResourceTypes.RESOURCE_BA.getId()));
        this.resourceIndexer = (IIndexer)resourceRepository.adapt(IIndexer.class);
        this.baRepository = baRepository;
        this.service = service;
    }

    public void handleEvent(SyncEvent event) {
        if (event.getAction() == SyncEvent.SyncAction.CREATE || event.getAction() == SyncEvent.SyncAction.UPDATE) {
            List<INodeRelation> relations = this.service.getRelationsByIds(Collections.emptyList());
            ArrayList<INodeRelation> relationsToAdd = new ArrayList<INodeRelation>(relations.size());
            for (INodeRelation relation : relations) {
                INode oldBa = this.resourceIndexer.getNode(BAMResourceTypes.RESOURCE_BA, relation.getTarget().getId());
                if (oldBa != null) {
                    INodeUtils.performDelta((INode)oldBa, (INode)relation.getTarget(), (boolean)true, (boolean)true, (boolean)true, (boolean)false);
                    continue;
                }
                relationsToAdd.add(relation);
            }
            this.baRepository.addRelations(relationsToAdd);
        } else if (event.getAction() == SyncEvent.SyncAction.REMOVE) {
            for (SyncEvent.SyncData data : event.getData()) {
                INodeRelation relation = null;
                while ((relation = INodeUtils.findRelationForTarget((INode)this.baRepository, null, (Long)data.getId(), (PropertyValue[])new PropertyValue[0])) != null) {
                    relation.getSource().removeRelation(relation);
                }
            }
        }
    }
}

