/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.resources.bam;

import com.centreon.studio.client.commons.Configuration;
import com.centreon.studio.client.commons.PropertiesMapper;
import com.centreon.studio.client.cxf.AWebService;
import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.exception.ExceptionEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.model.IWebService;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.properties.PropertyValue;
import com.centreon.studio.client.model.relation.INodeRelation;
import com.centreon.studio.client.model.relation.NodeRelationFactories;
import com.centreon.studio.client.utils.SequenceUtils;
import com.centreon.studio.client.utils.StepTimeTracker;
import com.centreon.studio.map.client.resources.bam.model.BAMResourcePropertyDescriptors;
import com.centreon.studio.map.client.resources.bam.model.BAMResourceTypes;
import com.centreon.studio.map.client.resources.bam.model.object.BAResource;
import com.centreon.studio.map.client.resources.bam.model.object.KPIBAResource;
import com.centreon.studio.map.client.resources.bam.model.object.KPIBooleanResource;
import com.centreon.studio.map.client.resources.bam.model.object.KPIMetaResource;
import com.centreon.studio.map.client.resources.bam.model.object.KPIServiceResource;
import com.centreon.studio.map.client.resources.bam.model.repository.BARepository;
import com.centreon.studio.map.client.resources.bam.model.repository.KPIRepository;
import com.centreon.studio.map.client.resources.model.ResourceTypes;
import com.centreon.studio.map.client.resources.model.object.abs.AResource;
import com.centreon.studio.map.resource.ResourceBaDto;
import com.centreon.studio.map.resource.ResourceKpiDto;
import com.centreon.studio.map.resourceservice.ResourcePortType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class BAMResourceWebService
extends AWebService<ResourcePortType>
implements IWebService {
    private final BrokerEventManager eventManager;
    private final KPIRepository kpiRepository;
    private final BARepository baRepository;

    private static BAResource dtoToBaResource(ResourceBaDto dto, BARepository baRepository, KPIRepository kpiRepository, Collection<INodeRelation> kpis) {
        BAResource ba = new BAResource(dto.getId(), PropertiesMapper.dtoToProperties((List)dto.getProperties(), (PropertyValue[])new PropertyValue[0]), baRepository);
        ArrayList<INodeRelation> children = new ArrayList<INodeRelation>(dto.getKpis().size());
        for (ResourceKpiDto kpiDto : dto.getKpis()) {
            INode kpi = BAMResourceWebService.dtoToKPIResource(kpiDto, kpiRepository, kpis);
            children.add(NodeRelationFactories.INSTANCE.create(ResourceTypes.RESOURCES, SequenceUtils.next(), (INode)ba, kpi));
            kpis.add(NodeRelationFactories.INSTANCE.create(ResourceTypes.RESOURCES, SequenceUtils.next(), (INode)kpiRepository, kpi));
        }
        ba.addRelations(children);
        return ba;
    }

    private static INode dtoToKPIResource(ResourceKpiDto dto, KPIRepository kpiRepository, Collection<INodeRelation> kpis) {
        Collection properties = PropertiesMapper.dtoToProperties((List)dto.getProperties(), (PropertyValue[])new PropertyValue[0]);
        TypeDescriptor actualType = null;
        for (PropertyValue prop : properties) {
            if (prop.getProperty() != BAMResourcePropertyDescriptors.KPI_SOURCE_TYPE) continue;
            actualType = BAMResourceTypes.getResourceKPITypeFromKPISubType((Integer)prop.getValue());
            break;
        }
        AResource kpi = null;
        if (actualType == BAMResourceTypes.RESOURCE_KPI_SERVICE) {
            kpi = new KPIServiceResource(dto.getId(), properties, kpiRepository);
        } else if (actualType == BAMResourceTypes.RESOURCE_KPI_META) {
            kpi = new KPIMetaResource(dto.getId(), properties, kpiRepository);
        } else if (actualType == BAMResourceTypes.RESOURCE_KPI_BOOLEAN) {
            kpi = new KPIBooleanResource(dto.getId(), properties, kpiRepository);
        } else if (actualType == BAMResourceTypes.RESOURCE_KPI_BA) {
            kpi = new KPIBAResource(dto.getId(), properties, kpiRepository);
        }
        if (kpi != null) {
            ArrayList<INodeRelation> children = new ArrayList<INodeRelation>(dto.getKpis().size());
            for (ResourceKpiDto kpiDto : dto.getKpis()) {
                INode child = BAMResourceWebService.dtoToKPIResource(kpiDto, kpiRepository, kpis);
                if (child == null) continue;
                children.add(NodeRelationFactories.INSTANCE.create(ResourceTypes.RESOURCES, SequenceUtils.next(), (INode)kpi, child));
                kpis.add(NodeRelationFactories.INSTANCE.create(ResourceTypes.RESOURCES, SequenceUtils.next(), (INode)kpiRepository, child));
            }
            kpi.addRelations(children);
        }
        return kpi;
    }

    @Inject
    public BAMResourceWebService(BrokerEventManager eventManager, BARepository baRepository, KPIRepository kpiRepository) {
        super("/centreon-studio/services/resource?wsdl", ResourcePortType.class, !Configuration.SKIP_GZIP);
        this.kpiRepository = kpiRepository;
        this.eventManager = eventManager;
        this.baRepository = baRepository;
    }

    public Map<INode, Collection<INodeRelation>> create(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        throw new IllegalAccessError();
    }

    public List<INodeRelation> getElementsByIds(List<Long> ids) {
        throw new UnsupportedOperationException();
    }

    public List<INodeRelation> getElementsByTypes(List<TypeDescriptor> types) {
        throw new IllegalAccessError();
    }

    public List<INodeRelation> getRelationsByIds(List<Long> ids) {
        if (!this.isInit()) {
            return Collections.emptyList();
        }
        StepTimeTracker counter = new StepTimeTracker("BAMResourceWebService.get()");
        try {
            List dtos = ((ResourcePortType)this.service).getBas(ids, true);
            ArrayList<INodeRelation> bams = new ArrayList<INodeRelation>(dtos.size());
            ArrayList<INodeRelation> kpis = new ArrayList<INodeRelation>(dtos.size());
            for (ResourceBaDto dto : dtos) {
                BAResource ba = BAMResourceWebService.dtoToBaResource(dto, this.baRepository, this.kpiRepository, kpis);
                bams.add(NodeRelationFactories.INSTANCE.create(ResourceTypes.RESOURCES, SequenceUtils.next(), (INode)this.baRepository, (INode)ba));
            }
            this.kpiRepository.addRelations(kpis);
            ArrayList<INodeRelation> arrayList = bams;
            return arrayList;
        }
        catch (Exception e) {
            this.eventManager.async((StudioEvent)new ExceptionEvent((Throwable)e));
            List<INodeRelation> list = Collections.emptyList();
            return list;
        }
        finally {
            this.eventManager.async((StudioEvent)LogEvent.trace(((Object)((Object)this)).getClass(), (String)counter.finish(), (Object[])new Object[0]));
        }
    }

    public boolean remove(Map<INode, Collection<INodeRelation>> nodeToRelations) {
        throw new IllegalAccessError();
    }

    public void update(Collection<INode> objects) {
        throw new IllegalAccessError();
    }

    public void updateRelation(Collection<INodeRelation> relations) {
        throw new IllegalAccessError();
    }
}

