/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets;

import com.centreon.studio.client.events.BrokerEventManager;
import com.centreon.studio.client.events.StudioEvent;
import com.centreon.studio.client.events.log.LogEvent;
import com.centreon.studio.client.gef.palette.CustomPaletteRoot;
import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.ui.actions.common.StudioAction;
import com.centreon.studio.client.model.ui.actionsets.ActionSetContributor;
import com.centreon.studio.client.model.ui.actionsets.ActionSetDescriptor;
import com.centreon.studio.map.client.elements.model.repository.decorators.ElementRepositoryDecorator;
import com.centreon.studio.map.client.elements.model.ui.actionsets.ElementEditorActionSetDescriptor;
import com.centreon.studio.map.client.elements.model.ui.parts.CustomPaletteViewer;
import com.centreon.studio.map.client.elements.model.ui.parts.ElementPalettePart;
import com.centreon.studio.map.client.elements.widgets.ui.WidgetPaletteRoot;
import com.centreon.studio.map.client.elements.widgets.ui.actionsets.ConvertToGraphAction;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public final class WidgetAddon {
    @PostConstruct
    public void postConstruct(BrokerEventManager eventManager, WidgetPaletteRoot widgetPaletteRoot, IEclipseContext context) {
        ElementPalettePart.register((CustomPaletteViewer.PaletteType)CustomPaletteViewer.PaletteType.WIDGET, (CustomPaletteRoot)widgetPaletteRoot);
        ActionSetContributor convertToGraphContrib = new ActionSetContributor(){

            public void contribute(List<StudioAction> actions, IEclipseContext context) {
                RepositoryDecorator repository = (RepositoryDecorator)ContextInjectionFactory.make(ElementRepositoryDecorator.class, (IEclipseContext)context);
                actions.add((StudioAction)new ConvertToGraphAction(repository));
            }
        };
        ActionSetDescriptor.contribute(ElementEditorActionSetDescriptor.class, (ActionSetContributor)convertToGraphContrib);
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Widget addon loaded", (Object[])new Object[0]));
    }

    @PreDestroy
    public void preDestroy(BrokerEventManager eventManager, WidgetPaletteRoot widgetPaletteRoot) {
        ElementPalettePart.unregister((CustomPaletteViewer.PaletteType)CustomPaletteViewer.PaletteType.WIDGET);
        eventManager.async((StudioEvent)LogEvent.trace(this.getClass(), (String)"Widget addon destroyed", (Object[])new Object[0]));
    }
}

