/*
 * Decompiled with CFR 0.152.
 */
package com.centreon.studio.map.client.elements.widgets.ui.actionsets;

import com.centreon.studio.client.model.decoration.repository.RepositoryDecorator;
import com.centreon.studio.client.model.node.INode;
import com.centreon.studio.client.model.node.INodeRelationListener;
import com.centreon.studio.client.model.node.INodeUtils;
import com.centreon.studio.client.model.object.TypeDescriptor;
import com.centreon.studio.client.model.property.PropertyDescriptors;
import com.centreon.studio.client.model.relation.INodeRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ClientCreatedRelations
implements INodeRelationListener {
    private final RepositoryDecorator repositoryDecorator;
    private final Map<Long, INodeRelation> clientsRelations;
    private final Collection<INodeRelation> serversRelations;
    private final Collection<INode> nodesWithListener;

    public ClientCreatedRelations(RepositoryDecorator repositoryDecorator, Collection<INodeRelation> relations) {
        this.repositoryDecorator = repositoryDecorator;
        this.nodesWithListener = new ArrayList<INode>(relations.size());
        this.serversRelations = new ArrayList<INodeRelation>(relations.size());
        this.clientsRelations = new HashMap<Long, INodeRelation>(relations.size());
        for (INodeRelation relation : relations) {
            INode source = relation.getSource();
            if (!this.nodesWithListener.contains(source)) {
                source.registerRelationsListener((INodeRelationListener)this);
                this.nodesWithListener.add(source);
            }
            this.clientsRelations.put(relation.getTarget().getId(), relation);
        }
    }

    public Collection<INodeRelation> getServerRelations() {
        return this.serversRelations;
    }

    public void relationsAdded(INode node, Collection<INodeRelation> relations) {
        for (INodeRelation relationFromServer : relations) {
            INodeRelation clientRelation;
            INode target = relationFromServer.getTarget();
            Long previousId = (Long)target.getProperty(PropertyDescriptors.PREVIOUS_ID);
            if (previousId == null || (clientRelation = this.clientsRelations.get(previousId)) == null) continue;
            this.clientsRelations.remove(previousId);
            INodeRelation decoratedRelation = INodeUtils.findRelation((INode)this.repositoryDecorator, (Long)relationFromServer.getId(), (TypeDescriptor[])new TypeDescriptor[0]);
            this.serversRelations.add(decoratedRelation);
        }
        if (this.clientsRelations.isEmpty()) {
            this.nodesWithListener.forEach(r -> r.unregisterRelationsListener((INodeRelationListener)this));
        }
    }

    public void relationsRemoved(INode node, Collection<INodeRelation> relations) {
    }
}

